<?php
namespace Admin\Model;
use Think\Model;
use ZipArchive;
class SysdataModel extends Model {

    static public $sqlFilesSize = 0;
    public $tableName='admin';
    /**
      +----------------------------------------------------------
     * 功能：获取数据库中所有表名
      +----------------------------------------------------------
     * @return array
      +----------------------------------------------------------
     */
    public function getAllTableName() {
        $tabs = M()->query('SHOW TABLE STATUS');
        $arr = array();
        foreach ($tabs as $tab) {
            $arr[] = $tab['Name'];
        }
        unset($tabs);
        return $arr;
    }

    /**
      +----------------------------------------------------------
     * 功能：读取数据库表结构信息
      +----------------------------------------------------------
     * @return string
      +----------------------------------------------------------
     */
    public function bakupTable($table_list) {
        M()->query("SET SQL_QUOTE_SHOW_CREATE = 1"); //1，表示表名和字段名会用``包着的,0 则不用``
        $outPut = '';
        if (!is_array($table_list) || empty($table_list)) {
            return false;
        }
        foreach ($table_list as $table) {
            $outPut.="# 数据库表：{$table} 结构信息\n";
            $outPut .= "DROP TABLE IF EXISTS `{$table}`;\n";
            $tmp = M()->query("SHOW CREATE TABLE {$table}");
            $outPut .= $tmp[0]['Create Table'] . " ;\n\n";
        }
        return $outPut;
    }

    /**
      +----------------------------------------------------------
     * 功能：读取已经备份SQL文件列表，并按备份时间倒序，名称升序排列
      +----------------------------------------------------------
     * @return array
      +----------------------------------------------------------
     */
    public function getSqlFilesList() {
        $list = array();
        $size = 0;
        $handle = opendir(DatabaseBackDir);

        while ($file = readdir($handle)) {
            if (preg_match('#\.sql$#i', $file)) {
                $fp = fopen(DatabaseBackDir . "/$file", 'rb');
                $bakinfo = fread($fp, 2000);
                fclose($fp);
                $detail = explode("\n", $bakinfo);
                $bk = array();
                $bk['name'] = $file;
                $bk['url'] = substr($detail[2], 7);
                $bk['type'] = substr($detail[3], 8);
                $bk['description'] = substr($detail[4], 14);
                $bk['time'] = substr($detail[5], 8);
                $_size = filesize(DatabaseBackDir . "/$file");
                $bk['size'] = byteFormat($_size);
                $size+=$_size;
                $bk['pre'] = substr($file, 0, strrpos($file, '_'));
                $bk['num'] = substr($file, strrpos($file, '_') + 1, strrpos($file, '.') - 1 - strrpos($file, '_'));
                $mtime = filemtime(DatabaseBackDir . "/$file");
                $list[$mtime][$file] = $bk;
            }
        }
        closedir($handle);
        krsort($list); //按备份时间倒序排列
        $newArr = array();
        foreach ($list as $k => $array) {
            ksort($array); //按备份文件名称顺序排列
            foreach ($array as $arr) {
                $newArr[] = $arr;
            }
        }
        unset($list);
        return array("list" => $newArr, "size" => byteFormat($size));
    }

    public function getZipFilesList() {
        $list = array();
        $size = 0;
        $handle = opendir(DatabaseBackDir . "Zip/");

        while ($file = readdir($handle)) {
            if ($file != "." && $file != "..") {
                $tem = array();
                $tem['file'] = $file; //  checkCharset($file);
                $_size = filesize(DatabaseBackDir . "Zip/$file");
                $tem['size'] = byteFormat($_size);
                $tem['time'] = date("Y-m-d H:i:s", filectime(DatabaseBackDir . "Zip/$file"));
                $size+=$_size;
                $list[] = $tem;
            }
        }
        return array("list" => $list, "size" => byteFormat($size));
    }

    /**
      +----------------------------------------------------------
     * 功能：生成zip压缩文件，存放都 WEB_CACHE_PATH 中
      +----------------------------------------------------------
     * @param $files        array   需要压缩的文件
     * @param $filename     string  压缩后的zip文件名  包括zip后缀
     * @param $path         string  文件所在目录
     * @param $outDir       string  输出目录
      +----------------------------------------------------------
     * @return array
      +----------------------------------------------------------
     */
    public function zip($files, $filename, $outDir = WEB_CACHE_PATH, $path = DatabaseBackDir) {
        $zip = new ZipArchive;
        makeDir($outDir);
        $res = $zip->open($outDir . "\\" . $filename, ZipArchive::CREATE);
        if ($res === TRUE) {
            foreach ($files as $file) {
                $zip->addFile($path . $file, str_replace('/', '', $file));
            }
            $zip->close();
            return TRUE;
        } else {
            return FALSE;
        }
    }

    /**
      +----------------------------------------------------------
     * 功能：解压缩zip文件，存放都 DatabaseBackDir 中
      +----------------------------------------------------------
     * @param $file         string   需要压缩的文件
     * @param $outDir       string   解压文件存放目录
      +----------------------------------------------------------
     * @return array
      +----------------------------------------------------------
     */
    function unzip($file, $outDir = DatabaseBackDir) {
        $zip = new ZipArchive();
        if ($zip->open(DatabaseBackDir . "Zip/" . $file) !== TRUE)
            return FALSE;
        $zip->extractTo($outDir);
        $zip->close();
        return TRUE;
    }
	//取得select/radio元素代码
	public function GetFSelect($type,$fname,$fvalue,$fsize=''){
	$vr=explode('|',$fvalue);
	$count=count($vr);
	$change='';
	$def=':default';
	for($i=0;$i<$count;$i++)
	{
		$isdef='';
		if(strstr($vr[$i],$def))
		{
			$dr=explode($def,$vr[$i]);
			$vr[$i]=$dr[0];
			$isdef="||\$ecmsfirstpost==1";
		}
		$selectvalr=explode('==',$vr[$i]);
		$val=$selectvalr[0];
		$valname=$selectvalr[1]?$selectvalr[1]:$selectvalr[0];
		if($type=='select')
		{
			$change.="<option value=\"".$val."\"<?php echo \$info[".$fname."]==\"".$val."\"".$isdef."?' selected':''?>>".$valname."</option>";
		}
		elseif($type=='checkbox')
		{
			$change.="<input name=\"".$fname."[]\"  id=\"".$fname."\" type=\"checkbox\" value=\"".$val."\" <?php echo strstr(\$info[".$fname."],\"|".$val."|\")".$isdef."?' checked':''?>>".$valname;
		}
		else
		{
			$change.="<input name=\"".$fname."\" type=\"radio\" id=\"".$fname."\" value=\"".$val."\"<?php echo \$info[".$fname."]==\"".$val."\"".$isdef."?' checked':''?>>".$valname;
		}
	}
	if($type=="select")
	{
		if($fsize)
		{
			$addsize=' style="width:'.$fsize.'"';
		}
		$change="<select name=\"".$fname."\" id=\"".$fname."\"".$addsize.">".$change."</select>";
	}
	return $change;
}
	
	
	//取得表单元素html代码
	public function GetFormhtml($type,$fname,$fvalue,$fsize='40')
	{
		if($type=="select"||$type=="radio"||$type=="checkbox")
		{
			return $this->GetFSelect($type,$fname,$fvalue,$fsize);
		}
			$file="./Public/Admin/Html/fhtml.html";
			$data=ReadText($file);
		    $string='';
		if(!empty($type)){
			$exp="[!--".$type."--]";
			$r=explode($exp,$data);
			$file=__ROOT__."/Public";
			$string=str_replace(array("[!--jcms.var--]","[!--fsize--]"),array($fname,$fsize),$r[1]);
			$string=str_replace("--PUBLIC--",$file,$string);
			$string=str_replace("--ROOT--",__ROOT__,$string);
		 }
		return addslashes($string);
	}
	
	function SetCreateTable($tbname,$tid)
	{
		$newsf=M('Enewsf');
		$dname=C('DB_PREFIX').$tbname;
		$sql="CREATE TABLE `".$dname."` (
		`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		`classid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
		`aid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
		`title` varchar(200)  NOT NULL DEFAULT '' COMMENT '标题',
		`special` varchar(200)  NOT NULL DEFAULT '' COMMENT '特殊属性',
		`titleurl` varchar(200) NOT NULL DEFAULT '' COMMENT '外部链接',
		`titlepic` varchar(225)  NOT NULL DEFAULT '' COMMENT '标题图片',
		`keywords` varchar(50) NOT NULL DEFAULT '' COMMENT '关键字',
		`description` text COMMENT '描述',
		`status` tinyint(2) NOT NULL DEFAULT '0',
		`smalltext` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
		`addtime` datetime,
		`update_time` int(11) DEFAULT NULL,
		`content` text,
		`click` int(11) NOT NULL DEFAULT '0',
		`target` char(30) NOT NULL DEFAULT '_self',
		`is_recommend` int(1) NOT NULL DEFAULT '0',
		 PRIMARY KEY (`id`),
		 KEY `classid` (`classid`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8";
		$sysfhtml=include("./Public/Admin/Html/SysHtml.php");
		$status=0;
		if(is_array($sysfhtml))
		{    $i=0;
			foreach($sysfhtml as $info)
			{
				$data[$i]['fname']=$info['fname'];
				$data[$i]['ftitle']=$info['ftitle'];
				$data[$i]['ftype']=$info['ftype'];
				$data[$i]['fform']=$info['fform'];
				$data[$i]['fvalue']=$info['fvalue'];
				$data[$i]['fsize']=$info['fsize'];
				$data[$i]['flen']=$info['flen'];
				$data[$i]['isadd']=$info['isadd'];
				$data[$i]['sort']=$info['sort'];
				$data[$i]['tbname']=$tbname;
				$data[$i]['tid']=$tid;
				$data[$i]['fhtml']=$this->GetFormhtml($info['fform'],$info['fname'],$info['fvalue'],$info['fsize']);
				$i++;
			}
			$status=$newsf->addAll($data);
		}

		if(M()->execute($sql)===0 && $status)
		{
			return true;
		}
	}
	

}

?>
