﻿SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for pa_admin
-- ----------------------------
DROP TABLE IF EXISTS `pa_admin`;
CREATE TABLE `pa_admin` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `nickname` varchar(20) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL COMMENT '登录账号',
  `password` char(32) DEFAULT NULL COMMENT '登录密码',
  `status` int(11) DEFAULT '1' COMMENT '账号状态',
  `role_id` int(11) DEFAULT '1' COMMENT '用户组',
  `remark` varchar(255) DEFAULT '' COMMENT '备注信息',
  `salt` char(10) DEFAULT NULL COMMENT '盐',
  `time` int(10) DEFAULT NULL COMMENT '开通时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='网站后台管理员表';

-- ----------------------------
-- Table structure for pa_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `pa_admin_log`;
CREATE TABLE `pa_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `aname` varchar(30) DEFAULT NULL COMMENT '管理员',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='操作登录日志';

-- ----------------------------
-- Records of pa_admin_log
-- ----------------------------

-- ----------------------------
-- Table structure for pa_ad_cate
-- ----------------------------
DROP TABLE IF EXISTS `pa_ad_cate`;
CREATE TABLE `pa_ad_cate` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL COMMENT '广告位名称',
  `status` tinyint(2) DEFAULT '0',
  `width` char(20) NOT NULL DEFAULT '',
  `height` char(20) NOT NULL DEFAULT '',
  `description` varchar(200) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告位表';

-- ----------------------------
-- Records of pa_ad_cate
-- ----------------------------

-- ----------------------------
-- Table structure for pa_ad_list
-- ----------------------------
DROP TABLE IF EXISTS `pa_ad_list`;
CREATE TABLE `pa_ad_list` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ad_name` varchar(60) NOT NULL DEFAULT '',
  `ad_link` varchar(255) NOT NULL DEFAULT '',
  `ad_img` varchar(255) NOT NULL,
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '50',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of pa_ad_list
-- ----------------------------

-- ----------------------------
-- Table structure for pa_category
-- ----------------------------
DROP TABLE IF EXISTS `pa_category`;
CREATE TABLE `pa_category` (
  `cid` int(5) NOT NULL AUTO_INCREMENT,
  `pid` int(5) DEFAULT NULL COMMENT '上级分类',
  `name` varchar(20) DEFAULT NULL COMMENT '分类名称',
  `type` char(2) NOT NULL DEFAULT 'n',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分类表';

-- ----------------------------
-- Records of pa_category
-- ----------------------------

-- ----------------------------
-- Table structure for pa_link
-- ----------------------------
DROP TABLE IF EXISTS `pa_link`;
CREATE TABLE `pa_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `status` int(1) NOT NULL,
  `link` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `sort` int(11) NOT NULL,
  `target` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of pa_link
-- ----------------------------

-- ----------------------------
-- Table structure for pa_member
-- ----------------------------
DROP TABLE IF EXISTS `pa_member`;
CREATE TABLE `pa_member` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '' COMMENT '账号',
  `mobile` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号码',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '邮箱地址',
  `nickname` varchar(20) NOT NULL DEFAULT '' COMMENT '昵称',
  `truename` varchar(20) NOT NULL DEFAULT '' COMMENT '姓名',
  `idcard` char(32) NOT NULL DEFAULT '' COMMENT '身份证',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `reg_date` int(10) NOT NULL DEFAULT '0',
  `reg_ip` char(15) NOT NULL DEFAULT '' COMMENT '注册IP地址',
  `avatar` varchar(100) NOT NULL DEFAULT '' COMMENT '用户头像',
  `birthday` int(10) NOT NULL DEFAULT '0' COMMENT '用户生日',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0女1男',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0 未激活 1激活',
  `intr` varchar(500) NOT NULL DEFAULT '' COMMENT '个人介绍',
  `phone` varchar(30) NOT NULL DEFAULT '' COMMENT '电话',
  `qq` int(15) NOT NULL DEFAULT '0',
  `login_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '登录ip',
  `login_time` int(10) NOT NULL DEFAULT '0' COMMENT '登录时间',
  `salt` char(10) NOT NULL DEFAULT '',
  `score` int(10) NOT NULL DEFAULT '0' COMMENT '积分',
  PRIMARY KEY (`uid`),
  KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员表';

-- ----------------------------
-- Records of pa_member
-- ----------------------------

-- ----------------------------
-- Table structure for pa_member_level
-- ----------------------------
DROP TABLE IF EXISTS `pa_member_level`;
CREATE TABLE `pa_member_level` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(30) DEFAULT NULL COMMENT '头衔名称',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '等级必要金额',
  `discount` smallint(4) DEFAULT NULL COMMENT '折扣',
  `describe` varchar(200) DEFAULT NULL COMMENT '头街 描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of pa_member_level
-- ----------------------------

-- ----------------------------
-- Table structure for pa_nav
-- ----------------------------
DROP TABLE IF EXISTS `pa_nav`;
CREATE TABLE `pa_nav` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `nav_name` varchar(255) NOT NULL,
  `pid` smallint(5) NOT NULL DEFAULT '0',
  `status` tinyint(1) DEFAULT NULL,
  `link` varchar(225) NOT NULL,
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '50',
  `target` char(20) NOT NULL DEFAULT '',
  `title` varchar(50) DEFAULT NULL COMMENT 'SEO标题',
  `keywords` varchar(150) DEFAULT NULL COMMENT 'SEO关键字',
  `description` varchar(200) DEFAULT NULL COMMENT 'SEO描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of pa_nav
-- ----------------------------

-- ----------------------------
-- Table structure for pa_news
-- ----------------------------
DROP TABLE IF EXISTS `pa_news`;
CREATE TABLE `pa_news` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `cid` smallint(3) DEFAULT NULL COMMENT '所在分类',
  `title` varchar(200) DEFAULT NULL COMMENT '新闻标题',
  `keywords` varchar(50) DEFAULT NULL COMMENT '文章关键字',
  `description` mediumtext COMMENT '文章描述',
  `link` varchar(200) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL COMMENT '文章摘要',
  `addtime` datetime DEFAULT NULL,
  `content` text,
  `click` int(11) NOT NULL DEFAULT '0',
  `aid` smallint(3) DEFAULT NULL COMMENT '发布者UID',
  `is_recommend` int(1) NOT NULL DEFAULT '0',
  `titlepic` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='新闻表';

-- ----------------------------
-- Records of pa_news
-- ----------------------------

-- ----------------------------
-- Table structure for pa_node
-- ----------------------------
DROP TABLE IF EXISTS `pa_node`;
CREATE TABLE `pa_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL COMMENT '权限名字',
  `group` varchar(20) DEFAULT NULL COMMENT '所属分组',
  `right` text COMMENT '权限码(控制器+动作)',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除状态 1删除,0正常',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of pa_node
-- ----------------------------
INSERT INTO `pa_node` VALUES ('1', '基本设置', 'system', 'System@index', '0');
INSERT INTO `pa_node` VALUES ('2', '清除缓存', 'system', 'System@cleancache', '0');
INSERT INTO `pa_node` VALUES ('3', '管理员列表', 'Site', 'System@admin,System@addAdmin,System@editAdmin', '0');
INSERT INTO `pa_node` VALUES ('4', '角色管理', 'system', 'System@role,System@addRole,System@editRole,System@delRole', '0');
INSERT INTO `pa_node` VALUES ('5', '权限列表', 'system', 'System@nodeList,System@addNode,System@editNode,System@delNode', '0');
INSERT INTO `pa_node` VALUES ('6', '操作日志', 'system', 'System@adminLog,System@delLog', '0');
INSERT INTO `pa_node` VALUES ('7', '数据备份', 'system', 'System@backup', '0');
INSERT INTO `pa_node` VALUES ('8', '文章列表', 'Site', 'Site@index,Site@addNews,Site@editNews,Site@delNews', '0');
INSERT INTO `pa_node` VALUES ('9', '文章分类', 'Site', 'Site@category', '0');
INSERT INTO `pa_node` VALUES ('10', '单页管理', 'Site', 'Site@page,Site@addPage,Site@editPage,Site@delPage', '0');
INSERT INTO `pa_node` VALUES ('11', '友情链接', 'Site', 'Site@linkList,Site@addLink,Site@editLink,Site@delLink', '0');
INSERT INTO `pa_node` VALUES ('12', '导航菜单', 'Site', 'Site@nav,Site@addNav,Site@editNav,Site@delNav', '0');
INSERT INTO `pa_node` VALUES ('13', '广告位', 'Site', 'Site@adCate,Site@addAdCate,Site@editAdCate,Site@delAdCate', '0');
INSERT INTO `pa_node` VALUES ('14', '广告列表', 'Site', 'Site@adList,Site@addAdList,Site@editAdList,Site@delAdList', '0');
INSERT INTO `pa_node` VALUES ('15', '会员列表', 'User', 'User@index', '0');
INSERT INTO `pa_node` VALUES ('16', '会员等级', 'User', 'User@level', '0');

-- ----------------------------
-- Table structure for pa_page
-- ----------------------------
DROP TABLE IF EXISTS `pa_page`;
CREATE TABLE `pa_page` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL COMMENT '新闻标题',
  `unique_id` varchar(30) NOT NULL DEFAULT '',
  `keywords` varchar(50) DEFAULT NULL COMMENT '文章关键字',
  `description` mediumtext COMMENT '文章描述',
  `link` varchar(200) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL COMMENT '文章摘要',
  `addtime` datetime DEFAULT NULL,
  `content` text,
  `click` int(11) NOT NULL DEFAULT '0',
  `aid` smallint(3) DEFAULT NULL COMMENT '发布者UID',
  `is_recommend` int(1) NOT NULL DEFAULT '0',
  `titlepic` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_id` (`unique_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='单页表';

-- ----------------------------
-- Records of pa_page
-- ----------------------------

-- ----------------------------
-- Table structure for pa_role
-- ----------------------------
DROP TABLE IF EXISTS `pa_role`;
CREATE TABLE `pa_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `pid` int(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `remark` varchar(255) DEFAULT '0',
  `act_list` text COMMENT '权限列表',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='权限角色表';

-- ----------------------------
-- Records of pa_role
-- ----------------------------
INSERT INTO `pa_role` VALUES ('1', '超级管理员', '0', '1', '系统内置超级管理员组，不受权限分配账号限制', 'all');

