<?php
namespace app\admin\model;
use think\Controller;
use think\Model;
use think\Db;
use think\Url;
use think\Session;
use think\Paginator;
use think\Request;
use think\Category;
class Common extends Model{

    public function getList($tbname,$map=[],$order='id desc')
    {
        if($tbname=='')
        {
            return false;
        }
        $list=db($tbname)->where($map)->order($order)->paginate( config('LIST_PAGE'));
        $res['list']=$list;
        $res['page']=$list->render();
        return $res;
    }
	
	 public function adminList($tbname,$map=[],$order='id desc')
    {
        if($tbname=='')
        {
            return false;
        }
		$levArr=db('level')->field('id,name')->select();
		foreach ($levArr as $k => $v) {
			$lev[$v['id']] = $v['name'];
		}
		unset($levArr);
        $list=db($tbname)->where($map)->order($order)->paginate( config('LIST_PAGE'))->each(function($item, $key)use($lev){
			$item['levelName'] = $lev[$item['lid']];
			return $item;
		});
        $res['list']=$list;
        $res['page']=$list->render();
        return $res;
    }


    public function addLog($info)
    {
        session_start();
        $data=[
            'aname'=>$_SESSION['my_info']['username'],
            'log_info'=>$info,
            'log_ip'=>request()->ip(),
            'log_time'=>time(),
        ];
        db('admin_log')->insert($data);
    }

    public function listNews($map=array())
    {
        $M = db("News");
        $statusArr = array("待审核", "已发布");
        $aidArr = db("Admin")->cache(true)->field("`aid`,`username`,`nickname`")->select();
        foreach ($aidArr as $k => $v) {
            $aids[$v['aid']] = $v;
        }
        unset($aidArr);
        $list = $M->where($map)->field("`id`,`title`,`status`,`addtime`,`uid`,`uname`,`aid`,`is_recommend`")->order("`addtime` DESC")->paginate( config('LIST_PAGE'))
                  ->each(function($item, $key)use($statusArr,$aids){
                      $item['aidName'] =$aids[$item['aid']]['nickname'] == '' ? $aids[$item['aid']]['username'] : $aids[$item['aid']]['nickname'];
                      $item['status'] = $statusArr[$item['status']];
                      return $item;
                });

        $res['list']=$list;
        $res['page']=$list->render();
        return $res;
    }

    public function listPage($map=array())
    {
        $M = db("Page");
        $statusArr = array("待审核", "已发布");
        $aidArr = db("Admin")->cache(true)->field("`aid`,`username`,`nickname`")->select();
        foreach ($aidArr as $k => $v) {
            $aids[$v['aid']] = $v;
        }
        unset($aidArr);
        $list = $M->where($map)->field("`id`,`title`,`status`,`addtime`,`aid`,`is_recommend`,`unique_id`")->order("`addtime` DESC")->paginate( config('LIST_PAGE'))
            ->each(function($item, $key)use($statusArr,$aids){
                $item['aidName'] =$aids[$item['aid']]['nickname'] == '' ? $aids[$item['aid']]['username'] : $aids[$item['aid']]['nickname'];
                $item['status'] = $statusArr[$item['status']];
                return $item;
            });

        $res['list']=$list;
        $res['page']=$list->render();
        return $res;
    }

    public function category()
    {
        $act = input('post.act');
        $data = input('post.data/a');
        $data['name'] = addslashes($data['name']);
        $M = db("Category");
        if ($act == "add") { //添加分类
            unset($data[cid]);
            if ($M->where($data)->count() == 0)
            {
                 return ($M->insert($data)) ? array('status' => 1, 'info' => '分类 ' . $data['name'] . ' 已经成功添加到系统中', 'url' => URL('Site/category', array('time' => time()))) : array('status' => 0, 'info' => '分类 ' . $data['name'] . ' 添加失败');
            }else
            {
                 return array('status' => 0, 'info' => '系统中已经存在分类' . $data['name']);
            }
          }else if($act == "edit")
          { //修改分类
            if (empty($data['name'])) {
                unset($data['name']);
            }
            if ($data['pid'] == $data['cid']) {
             unset($data['pid']);
            }
            return ($M->update($data)) ? array('status' => 1, 'info' => '分类 ' . $data['name'] . ' 已经成功更新', 'url' => URL('Site/category', array('time' => time()))) : array('status' => 0, 'info' => '分类 ' . $data['name'] . ' 更新失败');
         }else if ($act == "del")
         { //删除分类
            unset($data['pid'], $data['name']);
            if($M->where('pid='.$data['cid'].' AND cid!='.$data['cid'])->count()>0)
            {
                return (array('status' => 0, 'info' => $data['name'] . '存在下级分类，请先删除'));
                exit;
            }
            return ($M->where($data)->delete()) ? array('status' => 1, 'info' => '分类 ' . $data['name'] . ' 已经成功删除', 'url' => URL('Site/category', array('time' => time()))) : array('status' => 0, 'info' => '分类 ' . $data['name'] . ' 删除失败');
         }
    }

    public function listAdList()
    {


        $cidArr = db("ad_cate")->field("`id`,`name`,`width`,`height`")->where("status=1")->select();
        foreach ($cidArr as $k => $v) {
            $cids[$v['id']] = $v['name'].'('.$v['width'].'X'.$v['height'].'px)';
        }
        unset($cidArr);
        $list = db('ad_list')->order('id desc')->paginate( config('LIST_PAGE'))->each(function($item, $key)use($cids)
        {
            $item['cname'] = $cids[$item['cid']];
            return $item;
        });
        $res['list']=$list;
        $res['page']=$list->render();
        return $res;
    }

}