<?php
namespace app\admin\controller;
use think\Model;
use think\Db;
use think\Category;

class System extends Common
{
    /**
     +-------------------------------------------------------------------
     * @function 系统管理
     +--------------------------------------------------------------------
     */
    public function index()
    {
        if ($this->request->isPost())
        {
            $this->checkSystemConfig('SITE_INFO');

        }else
        {
            return  $this->fetch();
        }

    }
    /**
     +---------------------------------------------------------
     * 添加管理员
     +----------------------------------------------------------
     */

    public function addAdmin()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            if (!$data['username']) {
                ajaxReturn(array('status' => 0, 'info' => "请输入用户名"));
            }
            if (!$data['password']) {
                ajaxReturn(array('status' => 0, 'info' => "请输入密码"));
            }
            if (Db::name('Admin')->where("`username`='" . $data['username'] . "'")->count() > 0) {
                ajaxReturn(array('status' => 0, 'info' => "已经存在该账号"));
            }
            $data['nickname']=Db::name('Role')->where(['id'=>$data['role_id']])->value('name');
            $data['time'] = time();
            $data['salt']= randCode(6);
            $data['password'] = md5($data['salt'].md5($data['password']));
            $url=urldecode($data['url']);
            unset($data['url']);
            if(db('Admin')->insert($data))
            {
                Model('Common')->addLog('开通账号');
                ajaxReturn(array('status' => 1, 'info' => '账号已开通，请通知相关人员', 'url' =>$url));
            }else
            {
                ajaxReturn(array('status' => 0, 'info' => '添加新账号失败，请重试'));
            }

        }else
        {
            $this->assign("info", $this->getRoleListOption(array('role_id' => 0)));
			$this->assign("deport", config('deport'));
            return  $this->fetch();
        }

    }

    /**
    +---------------------------------------------------------
     * 修改管理员
    +----------------------------------------------------------
     */

    public function editAdmin()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            $info=$this->getList('Admin',['aid'=>$data['aid']]);
            if(empty($info))
            {
                ajaxReturn(array('status' => 0, 'info' => "不存在该管理员"));
            }
            if (!empty($data['password'])) {
                $data['password'] = md5($info['salt'].md5($data['password']));
            } else {
                unset($data['password']);
            }
            if (!$data['username']) {
                ajaxReturn(array('status' => 0, 'info' => "请输入用户名"));
            }
            $data['nickname']=Db::name('Role')->where(['id'=>$data['role_id']])->value('name');
            $url=urldecode($data['url']);
            unset($data['url']);
           if(db('Admin')->update($data))
           {
               Model('Common')->addLog('修改管理员');
               ajaxReturn(array('status' => 1, 'info' => '成功更新', 'url' =>$url));
           }else
           {
               ajaxReturn(array('status' => 0, 'info' => '更新失败，请重试'));
           };

        }else
        {
            $info=$this->getList('Admin',['aid'=>(int)input('aid')]);
            if(empty($info))
            {
                ajaxReturn(array('status' => 0, 'info' => "不存在该管理员"));
            }
			$this->assign("deport", config('deport'));
			$cat = new Category('level', array('id', 'pid', 'name', 'fullname'),'cid='.$info['cid']);
            $this->assign("level", $cat->getList());
            $this->assign("info", $this->getRoleListOption($info));
            return  $this->fetch('addAdmin');
        }

    }

    /**
     +-------------------------------------------------------------------
     * @function 管理员管理
     +--------------------------------------------------------------------
     */
    public function admin()
    {
        $res=Model('Common')->adminList('admin','','aid desc');
        $this->assign('list',$res['list']);
        $this->assign('page',$res['page']);
		$this->assign("deport", config('deport'));
        return  $this->fetch();
    }

    /**
    +-------------------------------------------------------------------
     * @function 角色管理
    +--------------------------------------------------------------------
     */
    public function role()
    {
        $res=Model('Common')->getList('role','');
        $this->assign('list',$res['list']);
        $this->assign('page',$res['page']);
        return  $this->fetch();
    }

    /**
    +-------------------------------------------------------------------
     * @function 添加角色
    +--------------------------------------------------------------------
     */
    public function addRole()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            if (!$data['name'])
            {
                ajaxReturn(array('status' => 0, 'info' => "角色组名称"));
            }
            if(!empty($data['right']))
            {
                $data['act_list']=join(',',$data['right']);
            }
            $url=urldecode($data['url']);
            unset($data['url'],$data['right']);
            db('Role')->insert($data) ? ajaxReturn(array('status' => 1, 'info' => '成功添加', 'url' =>$url)) : ajaxReturn(array('status' => 0, 'info' => '添加失败，请重试'));
        }else
        {
            $this->changeRole();
            return  $this->fetch();
        }
    }

    /**
    +-------------------------------------------------------------------
     * @function 修改角色
    +--------------------------------------------------------------------
     */
    public function editRole()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            if (!$data['name'])
            {
                ajaxReturn(array('status' => 0, 'info' => "名称为空"));
            }
            if(empty($data['id']))
            {
                ajaxReturn(array('status' => 0, 'info' => "不存在该节点"));
            }
            if(!empty($data['right']))
            {
                 $data['act_list']=join(',',$data['right']);
            }
            $url=urldecode($data['url']);
            unset($data['url'],$data['right']);
            db('Role')->update($data) ?ajaxReturn(array('status' => 1, 'info' => '成功更新', 'url' =>$url)) : ajaxReturn(array('status' => 0, 'info' => '更新失败，请重试'));

        }else
        {
            $M = db("Role");
            $info = $M->where("id=" . (int) input('id'))->find();
            if (empty($info['id'])) {
                $this->error("不存在该节点", URL('System/nodeList'));
            }
            $info['access']=json_encode(explode(',',$info['act_list']));
            $this->changeRole();
            $this->assign("info", $info);
            return  $this->fetch('addRole');
        }
    }
    /**
     +-------------------------------------------------------------------
     * @function 删除角色
     +--------------------------------------------------------------------
     */
    public function delRole()
    {
        if($this->request->isPost())
        {
            $ids=input('post.ids/a');
            $map['id']=array('in',$ids);
            if(db('Role')->where($map)->delete())
            {
                ajaxReturn(array('status'=>1));
            }else
            {
                ajaxReturn(array('status'=>0,'info'=>'操作失败！'));
            }
        }
    }
    /**
    +-------------------------------------------------------------------
     * @function 权限列表
    +--------------------------------------------------------------------
     */

    public function nodeList()
    {
        $list = db('node')->order('id ASC')->select();
        $this->assign('group',config('group'));
        $this->assign('list',$list);
        return  $this->fetch();
    }


    /**
    +-------------------------------------------------------------------
     * @function 添加权限节点
    +--------------------------------------------------------------------
     */
    public function addNode()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            if (!$data['name'])
            {
                ajaxReturn(array('status' => 0, 'info' => "名称为空"));
            }
            $data['right'] = implode(',',$data['right']);
            $url=urldecode($data['url']);
            unset($data['url']);
            db('node')->insert($data) ? ajaxReturn(array('status' => 1, 'info' => '成功添加', 'url' =>$url)) : ajaxReturn(array('status' => 0, 'info' => '添加失败，请重试'));
        }else
        {
            $this->getPid();
            return  $this->fetch();
        }
    }
    /**
    +-------------------------------------------------------------------
     * @function 修改权限节点
    +--------------------------------------------------------------------
     */
    public function editNode()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            if (!$data['name'])
            {
                ajaxReturn(array('status' => 0, 'info' => "名称为空"));
            }
            if(empty($data['id']))
            {
                ajaxReturn(array('status' => 0, 'info' => "不存在该节点"));
            }
            $data['right'] = implode(',',$data['right']);
            $url=urldecode($data['url']);
            unset($data['url']);
            db('Node')->update($data) ?ajaxReturn(array('status' => 1, 'info' => '更新节点信息成功', 'url' =>$url)) : ajaxReturn(array('status' => 0, 'info' => '更新节点信息失败'));

        }else
        {
            $M = db("Node");
            $info = $M->where("id=" . (int) input('id'))->find();
            if (empty($info['id'])) {
                $this->error("不存在该节点", URL('System/nodeList'));
            }
            $info['right'] = explode(',', $info['right']);
            $this->getPid();
            $this->assign("info",$info);
            return  $this->fetch('addNode');
        }
    }

    /**
    +-------------------------------------------------------------------
     * @function 删除节点
    +--------------------------------------------------------------------
     */
    public function delNode()
    {
        if($this->request->isPost())
        {
            $ids=input('post.ids/a');
            $map['id']=array('in',$ids);
            if(db('Node')->where($map)->delete())
            {
                ajaxReturn(array('status'=>1));
            }else
            {
                ajaxReturn(array('status'=>0,'info'=>'操作失败！'));
            }
        }
    }
    /**
    +-------------------------------------------------------------------
     * @function  操作列表
    +--------------------------------------------------------------------
     */

    public function adminLog()
    {
        $data=input('get.');
        if($data['time_end']!=''){
            $map['log_time']=array(array('gt',strtotime($data['time_start'])),array('lt',strtotime($data['time_end'])));
        }
        $res=Model('Common')->getList('admin_log',$map,'log_id desc');
        $this->assign('list',$res['list']);
        $this->assign('page',$res['page']);
        return  $this->fetch();
    }


    /**
    +-------------------------------------------------------------------
     * @function 删除操作日志
    +--------------------------------------------------------------------
     */
    public function delLog()
    {
        if($this->request->isPost())
        {
            $ids=input('post.ids/a');
            $map['log_id']=array('in',$ids);
            if(db('admin_log')->where($map)->delete())
            {
                Model('Common')->addLog('删除日志');
                ajaxReturn(array('status'=>1));
            }else
            {
                ajaxReturn(array('status'=>0,'info'=>'操作失败！'));
            }
        }
    }
    /**
     +-------------------------------------------------------------------
     * @function 数据备份
     +--------------------------------------------------------------------
     */

    public function backup()
    {
        $tabs = Db::query('SHOW TABLE STATUS');
        $total = 0;
        foreach ($tabs as $k => $v) {
            $tabs[$k]['size'] = byteFormat($v['Data_length'] + $v['Index_length']);
            $total+=$v['Data_length'] + $v['Index_length'];
        }
        $this->assign("list", $tabs);
        return  $this->fetch();
    }

    /**
    +----------------------------------------------------------
     * 备份数据库
    +----------------------------------------------------------
     */
    public function backupsql() {
        if ($this->request->isPost())
        header('Content-Type:application/json; charset=utf-8');
        function_exists('set_time_limit') && set_time_limit(0); //防止备份数据过程超时
        $tables = empty(input('post.ids/a')) ? array() : input('post.ids/a');
        if (count($tables) == 0) {
            die(json_encode(array("status" => 0, "info" => "请先选择要备份的表")));
        }
        $time = time();
        $type = "管理员后台手动备份";
        $path = DatabaseBackDir. date("Ymd") . "_" . randCode(5);
        $pre = "# -----------------------------------------------------------\n" .
            "# PHP-Amateur database backup files\n" .
            "# Blog: http://blog.51edm.org\n" .
            "# Type: {$type}\n";

        $bdTable = Model("System")->bakupTable($tables); //取得表结构信息
        $outPut = "";
        $file_n = 1;
        $backedTable = array();
        foreach ($tables as $table) {
            $backedTable[] = $table;
            $outPut.="\n\n# 数据库表：{$table} 数据信息\n";
            $tableInfo = Db::query("SHOW TABLE STATUS LIKE '{$table}'");
            $page = ceil($tableInfo[0]['Rows'] / 10000) - 1;
            for ($i = 0; $i <= $page; $i++) {
                $query = Db::query("SELECT * FROM {$table} LIMIT " . ($i * 10000) . ", 10000");
                foreach ($query as $val) {
                    $temSql = "";
                    $tn = 0;
                    $temSql = '';
                    foreach ($val as $v) {
                        $temSql.=$tn == 0 ? "" : ",";
                        $temSql.=$v == '' ? "''" : "'{$v}'";
                        $tn++;
                    }
                    $temSql = "INSERT INTO `{$table}` VALUES ({$temSql});\n";

                    $sqlNo = "\n# Time: " . date("Y-m-d H:i:s") . "\n" .
                        "# -----------------------------------------------------------\n" .
                        "# 当前SQL卷标：#{$file_n}\n# -----------------------------------------------------------\n\n\n";
                    if ($file_n == 1) {
                        $sqlNo = "# Description:当前SQL文件包含了表：" . implode("、", $tables) . "的结构信息，表：" . implode("、", $backedTable) . "的数据" . $sqlNo;
                    } else {
                        $sqlNo = "# Description:当前SQL文件包含了表：" . implode("、", $backedTable) . "的数据" . $sqlNo;
                    }
                    if (strlen($pre) + strlen($sqlNo) + strlen($bdTable) + strlen($outPut) + strlen($temSql) > 10485760) {
                        $file = $path . "_" . $file_n . ".sql";
                        $outPut = $file_n == 1 ? $pre . $sqlNo . $bdTable . $outPut : $pre . $sqlNo . $outPut;
                        file_put_contents($file, $outPut, FILE_APPEND);
                        $bdTable = $outPut = "";
                        $backedTable = array();
                        $backedTable[] = $table;
                        $file_n++;
                    }
                    $outPut.=$temSql;
                }
            }
        }
        if (strlen($bdTable . $outPut) > 0) {
            $sqlNo = "\n# Time: " . date("Y-m-d H:i:s") . "\n" .
                "# -----------------------------------------------------------\n" .
                "# 当前SQL卷标：#{$file_n}\n# -----------------------------------------------------------\n\n\n";
            if ($file_n == 1) {
                $sqlNo = "# Description:当前SQL文件包含了表：" . implode("、", $tables) . "的结构信息，表：" . implode("、", $backedTable) . "的数据" . $sqlNo;
            } else {
                $sqlNo = "# Description:当前SQL文件包含了表：" . implode("、", $backedTable) . "的数据" . $sqlNo;
            }
            $file = $path . "_" . $file_n . ".sql";
            $outPut = $file_n == 1 ? $pre . $sqlNo . $bdTable . $outPut : $pre . $sqlNo . $outPut;
            file_put_contents($file, $outPut, FILE_APPEND);
            $file_n++;
        }
        $time = time() - $time;
        echo json_encode(array("status" => 1, "info" => "成功备份所选数据库表结构和数据"));
    }


    /**
    +-------------------------------------------------------------------
     * @function 清除缓存
    +--------------------------------------------------------------------
     */

    public function cleancache()
    {
        $caches = array(

            "Log" => array("name" => "日志缓存文件", "path" =>dirname(APP_PATH) . "/runtime/log"),
            "Temp" => array("name" => "临时缓存文件", "path" => dirname(APP_PATH) . "/runtime/temp"),
            "Cache" => array("name" => "缓存文件", "path" => dirname(APP_PATH) . "/runtime/cache")
        );
        if ($this->request->isPost()) {
            foreach ($_POST['cache'] as $path) {
                if (isset($caches[$path]))
                    delDirAndFile($caches[$path]['path']);
            }
            ajaxReturn(array("status"=>1,"info"=>"缓存文件已清除"));
        } else {
            $this->assign("caches", $caches);
            return  $this->fetch();
        }

    }


    /**
    +----------------------------------------------------------
     * 网站配置信息保存操作等
    +----------------------------------------------------------
     */
    private function checkSystemConfig($obj = "SITE_INFO") {
        if ($this->request->isPost()) {

            $config = APP_PATH . "systemConfig.php";
            $config = file_exists($config) ? include "$config" : array();
            $config = is_array($config) ? $config : array();
            $config = array_merge($config, array("$obj" =>input('post.')));
            if (set_config("systemConfig", $config, APP_PATH ))
            {
                ajaxReturn(array('status' => 1, 'info' => '更新成功'));
            } else {
                ajaxReturn(array('status' => 0, 'info' =>'更新失败，请检查', 'url' => __SELF__));
            }
        }
    }


    private function getPid()
    {
        $group = config('group');
        $deny_list=config('module_deny_list');
        $planPath = APP_PATH.'admin/controller';
        $planList = array();
        $dirRes   = opendir($planPath);
        while($dir = readdir($dirRes))
        {
            if(!in_array($dir,array('.','..','.svn')))
            {
                $filename=basename($dir,'.php');
                if(!in_array($filename,$deny_list))
                {
                    $planList[] = $filename;
                }
            }
        }
        $this->assign('planList',$planList);
        $this->assign('group',$group);
    }

    public  function ajax_get_action()
    {
        $control = input('post.controller');
        $advContrl = get_class_methods("app\\admin\\controller\\".str_replace('.php','',$control));
        $baseContrl = get_class_methods('app\admin\controller\Common');
        $diffArray  = array_diff($advContrl,$baseContrl);
        $html = '';
        foreach ($diffArray as $val){
            $html .= "<option value='".$val."'>".$val."</option>";
        }
        exit($html);
    }

    private function getRoleListOption($info = array()) {
        $cat = new Category('Role', array('id', 'pid', 'name', 'fullname'));
        $list = $cat->getList(); //获取分类结构
        $info['roleOption'] = "";
        foreach ($list as $v) {
            $disabled = $v['id'] == 1 ? ' disabled="disabled"' : "";
            $selected = $v['id'] == $info['role_id'] ? ' selected="selected"' : "";
            $info['roleOption'].='<option value="' . $v['id'] . '"' . $selected . $disabled . '>' . $v['fullname'] . '</option>';
        }
        return $info;
    }

    private function changeRole()
    {
        $right = db('node')->order('id')->select();
        foreach ($right as $val){
            if(!empty($detail)){
                $val['enable'] = in_array($val['id'], $detail['act_list']);
            }
            $modules[$val['group']][] = $val;
        }
        $this->assign('group',config('group'));
        $this->assign('modules',$modules);
    }

}