<?php
namespace app\admin\controller;
use think\Controller;
use think\Db;
use think\Session;
use think\Verify;
class Member extends Controller
{
    public function login()
    {
        if($this->request->isPost())
        {
            $data=input('post.');
            $LoginInfo=Model('Member')->auth($data);
            if($LoginInfo)
            {
                Model('Common')->addLog('后台登录');
                ajaxReturn(array('status' =>1, 'info' => "登录成功",'url'=>URL('Index/index')));
            }
        }else
        {
            $this->view->engine->layout(false);
            return  $this->fetch();
        }
    }

    public function loginOut()
    {
        session_start();
        setcookie("loginTime", NULL, -3600, "/");
        Model('Common')->addLog('安全退出');
        unset($_SESSION['my_info']);
        $this->redirect("Index/index");
    }


    /**
     * 验证码获取
     */
    public function vertify()
    {
        $config = array(
            'fontSize' => 30,
            'length' => 4,
            'useCurve' => true,
            'useNoise' => false,
            'reset' => false
        );
        $Verify = new Verify($config);
        $Verify->entry("admin_login");
        exit();
    }
}
