<?php
namespace app\admin\controller;
use think\Db;

class Index extends Common
{
    public function index()
    {
       $this->user();
       $this->assign('sys_info',$this->get_sys_info());
       return  $this->fetch();
    }

    private function user()
    {
        $begin=strtotime(date('Y-m-d',strtotime("-1 month")));
        $end=strtotime(date('Y-m-d'))+86399;
        $new=db('Member')->where(" reg_date>=$begin and reg_date<=$end")->field("COUNT(*) as num,FROM_UNIXTIME(reg_date,'%Y-%m-%d') as gap")->group("gap")->select();
        foreach ($new as $val){
            $arr[$val['gap']] = $val['num'];
        }

            for($i=$begin;$i<=$end;$i=$i+24*3600) {
            $brr[] = empty($arr[date('Y-m-d', $i)]) ? 0 : $arr[date('Y-m-d', $i)];
            $day[] = date('Y-m-d', $i);
        }
        $result = array('data'=>$brr,'time'=>$day);
        $this->assign('result',json_encode($result));
    }

    public function get_sys_info(){
        $sys_info['os']             = PHP_OS;
        $sys_info['zlib']           = function_exists('gzclose') ? 'YES' : 'NO';//zlib
        $sys_info['safe_mode']      = (boolean) ini_get('safe_mode') ? 'YES' : 'NO';//safe_mode = Off
        $sys_info['timezone']       = function_exists("date_default_timezone_get") ? date_default_timezone_get() : "no_timezone";
        $sys_info['curl']			= function_exists('curl_init') ? 'YES' : 'NO';
        $sys_info['web_server']     = $_SERVER['SERVER_SOFTWARE'];
        $sys_info['phpv']           = phpversion();
        $sys_info['ip'] 			= GetHostByName($_SERVER['SERVER_NAME']);
        $sys_info['fileupload']     = @ini_get('file_uploads') ? ini_get('upload_max_filesize') :'unknown';
        $sys_info['max_ex_time'] 	= @ini_get("max_execution_time").'s'; //脚本最大执行时间
        $sys_info['set_time_limit'] = function_exists("set_time_limit") ? true : false;
        $sys_info['domain'] 		= $_SERVER['HTTP_HOST'];
        $sys_info['memory_limit']   = ini_get('memory_limit');
        $mysqlinfo = Db::query("SELECT VERSION() as version");
        $sys_info['mysql_version']  = $mysqlinfo[0]['version'];
        if(function_exists("gd_info")){
            $gd = gd_info();
            $sys_info['gdinfo'] 	= $gd['GD Version'];
        }else {
            $sys_info['gdinfo'] 	= "未知";
        }
        return $sys_info;
    }
}
