<?php
namespace app\admin\controller;
use think\Controller;
use think\Db;
use think\Session;
use think\Verify;
use think\Request;


class Common extends Controller
{
    public function _initialize()
    {
        session_start();
        $this->checkLogin();
        $this->assign("my_info", $_SESSION['my_info']);
        $this->assign('menu',getMenu());
        $aname=Request::instance()->controller();
        $mname=Request::instance()->action();
        $this->assign('aname',$aname);
        $this->assign('mname',$mname);
        $this->assign('subMenu',getNextMenu($aname));
        $systemConfig = include APP_PATH . 'systemConfig.php';
        $this->assign("site", $systemConfig);
        $this->checkAuth($aname,$mname);
    }

    public function checkAuth($ctl,$act)
    {
        $act_list = $_SESSION['my_info']['act_list'];
        //无需验证的操作
        $uneed_check = array('login','logout','vertify','upload');
        if($ctl == 'Index' || $act_list == 'all'){
            //后台首页控制器无需验证,超级管理员无需验证
            return true;
        }elseif(in_array($act,$uneed_check)){
            return true;
        }else{
            $role_right='';
            $right = db('node')->where("id", "in", $act_list)->cache(true)->column('right');
            foreach ($right as $val){
                $role_right .= strtolower($val).',';
            }
            $role_right = explode(',', $role_right);
            //检查是否拥有此操作权限
            if(!in_array(strtolower($ctl.'@'.$act), $role_right)){
                $this->error('您没有操作权限!',URL('Admin/Index/index'));
            }
        }
    }

    public function checkLogin()
    {
        if (isset($_COOKIE['loginTime'])) {
            $loginTime=$_COOKIE['loginTime'];
            if (time() > ($loginTime + config('admin_timeout')))
            {
                setcookie("loginTime", NULL, -3600, "/");
                unset($_SESSION['my_info']);
               $this->error("登录超时，请重新登录", URL("Member/login"));
            } else {
                setcookie("loginTime",time(), 0, "/");
            }
        } else {
              $this->redirect("Member/login");
        }
        return true;
    }

    /**
    +-----------------------------------------------------------------------------------
     * @function  获取数据
    +----------------------------------------------------------------------------------
     */

    public function getList($tbname,$map=array(),$listRows=0)
    {
        if($tbname=='')
        {
            return false;
        }
        if($listRows==0)
        {
            $list=db($tbname)->where($map)->find();
        }else
        {
            $list=db($tbname)->where($map)->limit($listRows)->select();
        }
        return $list;
    }

}