<?php
function check_verify($code, $id = ''){
    $verify = new \think\Verify();
    return $verify->check($code, $id);
}


/**
 +--------------------------------------------------------------------
 * 获取后台菜单
 +--------------------------------------------------------------------
 */
function getMenu()
{
    $menuArr = include APP_PATH.'admin/conf/menu.php';
    $menu=[];
    foreach($menuArr as $k=>$val){
        $menu[$k]['name']=$val['name'];
        $menu[$k]['url']=$k.'/'.$val['act'];
    }
    return $menu;
}

//获取二级菜单
function getNextMenu($aname)
{
    $menuArr = include APP_PATH.'admin/conf/menu.php';
    $act_list = $_SESSION['my_info']['act_list'];
    $role_right='';
    if($act_list != 'all' && !empty($act_list))
    {
        $right =  db('node')->where("id", "in", $act_list)->cache(true)->column('right');
        foreach ($right as $val){
            $role_right .= $val.',';
        }
        if(isset($menuArr[$aname]))
        {
            $menu=$menuArr[$aname];
            foreach ($menu['child'] as $j=>$v){
                foreach ($v['child'] as $s=>$son){
                    if(!strpos(strtolower($role_right),strtolower($son['op'].'@'.$son['act']))){
                        unset($menu['child'][$j]['child'][$s]);//过滤菜单
                    }
                }
            }
            return $menu;
        }
    }else
    {
        if(isset($menuArr[$aname]))
        {
            return $menuArr[$aname];
        }
    }

}


/**
+----------------------------------------------------------
 * 生成随机字符串
+----------------------------------------------------------
 * @param int       $length  要生成的随机字符串长度
 * @param string    $type    随机码类型：0，数字+大写字母；1，数字；2，小写字母；3，大写字母；4，特殊字符；-1，数字+大小写字母+特殊字符
+----------------------------------------------------------
 * @return string
+----------------------------------------------------------
 */
function randCode($length = 5, $type = 0) {
    $arr = array(1 => "0123456789", 2 => "abcdefghijklmnopqrstuvwxyz", 3 => "ABCDEFGHIJKLMNOPQRSTUVWXYZ", 4 => "~@#$%^&*(){}[]|");
    if ($type == 0) {
        array_pop($arr);
        $string = implode("", $arr);
    } else if ($type == "-1") {
        $string = implode("", $arr);
    } else {
        $string = $arr[$type];
    }
    $count = strlen($string) - 1;
    for ($i = 0; $i < $length; $i++) {
        $str[$i] = $string[rand(0, $count)];
        $code .= $str[$i];
    }
    return $code;
}



/**
+----------------------------------------------------------
 * 功能：计算文件大小
+----------------------------------------------------------
 * @param int $bytes
+----------------------------------------------------------
 * @return string 转换后的字符串
+----------------------------------------------------------
 */
function byteFormat($bytes) {
    $sizetext = array(" B", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
    return round($bytes / pow(1024, ($i = floor(log($bytes, 1024)))), 2) . $sizetext[$i];
}
