/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50714
Source Host           : localhost:3306
Source Database       : wxlz

Target Server Type    : MYSQL
Target Server Version : 50714
File Encoding         : 65001

Date: 2020-09-16 16:35:24
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `wx_admin`
-- ----------------------------
DROP TABLE IF EXISTS `wx_admin`;
CREATE TABLE `wx_admin` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `nickname` varchar(20) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL COMMENT '登录账号',
  `password` char(32) DEFAULT NULL COMMENT '登录密码',
  `status` int(11) DEFAULT '1' COMMENT '账号状态',
  `role_id` int(11) DEFAULT '1' COMMENT '用户组',
  `remark` varchar(255) DEFAULT '' COMMENT '备注信息',
  `salt` char(10) DEFAULT NULL COMMENT '盐',
  `time` int(10) DEFAULT NULL COMMENT '开通时间',
  `cid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
  `lid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='网站后台管理员表';

-- ----------------------------
-- Records of wx_admin
-- ----------------------------
INSERT INTO `wx_admin` VALUES ('1', '超级管理员', 'adminwx', 'cd901b5e8afcfee916170f3a822c2b4b', '1', '1', '我是超级管理员', 'EWpwL6', '1598512478', '0', '0');
INSERT INTO `wx_admin` VALUES ('2', '网格长', 'wangge001', '824dba797c3fc454c8acdd0630efde91', '1', '2', '网格管理', 'ydjAsO', '1599216328', '1', '2');
INSERT INTO `wx_admin` VALUES ('3', '网格长', 'sncxh', '5bb02f867e472ac26df1f2860412eadc', '1', '2', '', 'sPaNmU', '1599457437', '3', '117');
INSERT INTO `wx_admin` VALUES ('4', '网格长', 'lzzsnc', 'ba273c45a7b33cde2b45562dc34351c6', '1', '2', '', 'qsdzdT', '1599458148', '1', '2');

-- ----------------------------
-- Table structure for `wx_admin_log`
-- ----------------------------
DROP TABLE IF EXISTS `wx_admin_log`;
CREATE TABLE `wx_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `aname` varchar(30) DEFAULT NULL COMMENT '管理员',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COMMENT='操作登录日志';

-- ----------------------------
-- Records of wx_admin_log
-- ----------------------------
INSERT INTO `wx_admin_log` VALUES ('1', 'adminwx', '后台登录', '0.0.0.0', '1598512633');
INSERT INTO `wx_admin_log` VALUES ('2', 'adminwx', '安全退出', '0.0.0.0', '1598512668');
INSERT INTO `wx_admin_log` VALUES ('3', 'adminwx', '后台登录', '0.0.0.0', '1598512688');
INSERT INTO `wx_admin_log` VALUES ('4', 'adminwx', '后台登录', '222.91.197.35', '1598586854');
INSERT INTO `wx_admin_log` VALUES ('5', 'adminwx', '后台登录', '222.91.197.35', '1598600046');
INSERT INTO `wx_admin_log` VALUES ('6', 'adminwx', '后台登录', '49.75.203.167', '1598608559');
INSERT INTO `wx_admin_log` VALUES ('7', 'adminwx', '后台登录', '49.75.203.167', '1598669069');
INSERT INTO `wx_admin_log` VALUES ('8', 'adminwx', '后台登录', '222.91.199.140', '1598852752');
INSERT INTO `wx_admin_log` VALUES ('9', 'adminwx', '后台登录', '222.91.199.140', '1598864756');
INSERT INTO `wx_admin_log` VALUES ('10', 'adminwx', '后台登录', '49.75.203.167', '1598880686');
INSERT INTO `wx_admin_log` VALUES ('11', 'adminwx', '后台登录', '222.91.199.167', '1599037107');
INSERT INTO `wx_admin_log` VALUES ('12', 'adminwx', '后台登录', '180.117.179.13', '1599039092');
INSERT INTO `wx_admin_log` VALUES ('13', 'adminwx', '后台登录', '222.91.199.167', '1599043648');
INSERT INTO `wx_admin_log` VALUES ('14', 'adminwx', '后台登录', '180.117.179.13', '1599102795');
INSERT INTO `wx_admin_log` VALUES ('15', 'adminwx', '安全退出', '180.117.179.13', '1599103564');
INSERT INTO `wx_admin_log` VALUES ('16', 'adminwx', '后台登录', '180.117.179.13', '1599103604');
INSERT INTO `wx_admin_log` VALUES ('17', 'adminwx', '后台登录', '222.91.149.176', '1599112239');
INSERT INTO `wx_admin_log` VALUES ('18', 'adminwx', '后台登录', '180.117.179.13', '1599112514');
INSERT INTO `wx_admin_log` VALUES ('19', 'adminwx', '后台登录', '222.91.149.176', '1599200799');
INSERT INTO `wx_admin_log` VALUES ('20', 'adminwx', '后台登录', '222.91.149.176', '1599213301');
INSERT INTO `wx_admin_log` VALUES ('21', 'adminwx', '开通账号', '222.91.199.42', '1599216328');
INSERT INTO `wx_admin_log` VALUES ('22', 'adminwx', '修改管理员', '222.91.199.42', '1599216341');
INSERT INTO `wx_admin_log` VALUES ('23', 'adminwx', '修改管理员', '222.91.199.42', '1599216442');
INSERT INTO `wx_admin_log` VALUES ('24', 'adminwx', '修改管理员', '222.91.199.42', '1599216463');
INSERT INTO `wx_admin_log` VALUES ('25', 'wangge001', '后台登录', '222.91.199.42', '1599216803');
INSERT INTO `wx_admin_log` VALUES ('26', 'wangge001', '安全退出', '222.91.199.42', '1599216908');
INSERT INTO `wx_admin_log` VALUES ('27', 'wangge001', '后台登录', '222.91.199.42', '1599216922');
INSERT INTO `wx_admin_log` VALUES ('28', 'wangge001', '安全退出', '222.91.199.42', '1599217094');
INSERT INTO `wx_admin_log` VALUES ('29', 'wangge001', '后台登录', '222.91.199.42', '1599217117');
INSERT INTO `wx_admin_log` VALUES ('30', 'wangge001', '安全退出', '222.91.199.42', '1599217694');
INSERT INTO `wx_admin_log` VALUES ('31', 'wangge001', '后台登录', '222.91.199.42', '1599217706');
INSERT INTO `wx_admin_log` VALUES ('32', 'wangge001', '安全退出', '222.91.199.42', '1599219752');
INSERT INTO `wx_admin_log` VALUES ('33', 'wangge001', '后台登录', '222.91.199.42', '1599219764');
INSERT INTO `wx_admin_log` VALUES ('34', 'wangge001', '后台登录', '222.91.199.42', '1599220485');
INSERT INTO `wx_admin_log` VALUES ('35', 'adminwx', '后台登录', '112.80.17.214', '1599281514');
INSERT INTO `wx_admin_log` VALUES ('36', 'adminwx', '后台登录', '180.117.179.13', '1599455526');
INSERT INTO `wx_admin_log` VALUES ('37', 'adminwx', '后台登录', '58.210.45.170', '1599457028');
INSERT INTO `wx_admin_log` VALUES ('38', 'adminwx', '开通账号', '58.210.45.170', '1599457437');
INSERT INTO `wx_admin_log` VALUES ('39', 'adminwx', '安全退出', '58.210.45.170', '1599457614');
INSERT INTO `wx_admin_log` VALUES ('40', 'sncxh', '后台登录', '58.210.45.170', '1599457630');
INSERT INTO `wx_admin_log` VALUES ('41', 'sncxh', '安全退出', '58.210.45.170', '1599458019');
INSERT INTO `wx_admin_log` VALUES ('42', 'adminwx', '后台登录', '58.210.45.170', '1599458057');
INSERT INTO `wx_admin_log` VALUES ('43', 'adminwx', '开通账号', '58.210.45.170', '1599458148');
INSERT INTO `wx_admin_log` VALUES ('44', 'adminwx', '安全退出', '58.210.45.170', '1599458156');
INSERT INTO `wx_admin_log` VALUES ('45', 'lzzsnc', '后台登录', '58.210.45.170', '1599458171');
INSERT INTO `wx_admin_log` VALUES ('46', 'lzzsnc', '后台登录', '58.210.45.170', '1599458859');
INSERT INTO `wx_admin_log` VALUES ('47', 'adminwx', '后台登录', '180.117.179.13', '1599459292');
INSERT INTO `wx_admin_log` VALUES ('48', 'lzzsnc', '安全退出', '58.210.45.170', '1599459350');
INSERT INTO `wx_admin_log` VALUES ('49', 'adminwx', '后台登录', '58.210.45.170', '1599459391');
INSERT INTO `wx_admin_log` VALUES ('50', 'adminwx', '后台登录', '219.145.47.27', '1599459512');
INSERT INTO `wx_admin_log` VALUES ('51', 'adminwx', '后台登录', '58.210.45.170', '1599460308');
INSERT INTO `wx_admin_log` VALUES ('52', 'adminwx', '安全退出', '58.210.45.170', '1599460499');
INSERT INTO `wx_admin_log` VALUES ('53', 'adminwx', '后台登录', '58.210.45.170', '1599460524');
INSERT INTO `wx_admin_log` VALUES ('54', 'adminwx', '安全退出', '58.210.45.170', '1599460896');
INSERT INTO `wx_admin_log` VALUES ('55', 'adminwx', '后台登录', '58.210.45.170', '1599460912');
INSERT INTO `wx_admin_log` VALUES ('56', 'adminwx', '安全退出', '219.145.47.27', '1599462223');
INSERT INTO `wx_admin_log` VALUES ('57', 'adminwx', '后台登录', '58.210.45.170', '1599462454');
INSERT INTO `wx_admin_log` VALUES ('58', 'adminwx', '后台登录', '58.210.45.170', '1599465161');
INSERT INTO `wx_admin_log` VALUES ('59', 'adminwx', '后台登录', '222.91.148.57', '1599472504');
INSERT INTO `wx_admin_log` VALUES ('60', 'adminwx', '安全退出', '58.210.45.170', '1599476787');
INSERT INTO `wx_admin_log` VALUES ('61', 'adminwx', '后台登录', '58.210.45.170', '1599479983');
INSERT INTO `wx_admin_log` VALUES ('62', 'adminwx', '安全退出', '58.210.45.170', '1599480496');
INSERT INTO `wx_admin_log` VALUES ('63', 'adminwx', '后台登录', '58.210.45.170', '1599526886');
INSERT INTO `wx_admin_log` VALUES ('64', 'adminwx', '后台登录', '222.91.148.57', '1599530417');
INSERT INTO `wx_admin_log` VALUES ('65', 'adminwx', '后台登录', '180.117.179.13', '1599531423');
INSERT INTO `wx_admin_log` VALUES ('66', 'adminwx', '后台登录', '180.117.179.13', '1599545011');
INSERT INTO `wx_admin_log` VALUES ('67', 'adminwx', '后台登录', '58.210.45.170', '1599552113');
INSERT INTO `wx_admin_log` VALUES ('68', 'adminwx', '安全退出', '58.210.45.170', '1599552462');
INSERT INTO `wx_admin_log` VALUES ('69', 'adminwx', '后台登录', '58.210.45.170', '1599552535');
INSERT INTO `wx_admin_log` VALUES ('70', 'adminwx', '后台登录', '180.117.179.13', '1599552973');
INSERT INTO `wx_admin_log` VALUES ('71', 'adminwx', '后台登录', '58.210.45.170', '1599612902');
INSERT INTO `wx_admin_log` VALUES ('72', 'adminwx', '后台登录', '58.210.45.170', '1599724234');
INSERT INTO `wx_admin_log` VALUES ('73', 'adminwx', '后台登录', '180.117.179.13', '1599729887');

-- ----------------------------
-- Table structure for `wx_ad_cate`
-- ----------------------------
DROP TABLE IF EXISTS `wx_ad_cate`;
CREATE TABLE `wx_ad_cate` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL COMMENT '广告位名称',
  `status` tinyint(2) DEFAULT '0',
  `width` char(20) NOT NULL DEFAULT '',
  `height` char(20) NOT NULL DEFAULT '',
  `description` varchar(200) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告位表';

-- ----------------------------
-- Records of wx_ad_cate
-- ----------------------------
INSERT INTO `wx_ad_cate` VALUES ('1', '资源banner', '1', '366', '204', '');

-- ----------------------------
-- Table structure for `wx_ad_list`
-- ----------------------------
DROP TABLE IF EXISTS `wx_ad_list`;
CREATE TABLE `wx_ad_list` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ad_name` varchar(60) NOT NULL DEFAULT '',
  `ad_link` varchar(255) NOT NULL DEFAULT '',
  `ad_img` varchar(255) NOT NULL,
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '50',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wx_ad_list
-- ----------------------------
INSERT INTO `wx_ad_list` VALUES ('1', '1', '资源banner', '', '/uploads/image/images/20200831/20200831054927_70353.png', '50', '1');

-- ----------------------------
-- Table structure for `wx_amount`
-- ----------------------------
DROP TABLE IF EXISTS `wx_amount`;
CREATE TABLE `wx_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在等级',
  `lid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
  `unkey` int(10) NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`),
  KEY `lid` (`lid`),
  KEY `unkey` (`unkey`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='资源表';

-- ----------------------------
-- Records of wx_amount
-- ----------------------------
INSERT INTO `wx_amount` VALUES ('9', '1', '1', '0', '3');
INSERT INTO `wx_amount` VALUES ('10', '3', '30', '0', '2');
INSERT INTO `wx_amount` VALUES ('11', '3', '30', '1', '6');
INSERT INTO `wx_amount` VALUES ('13', '3', '30', '3', '1');
INSERT INTO `wx_amount` VALUES ('14', '3', '30', '4', '1');
INSERT INTO `wx_amount` VALUES ('15', '3', '30', '2', '1');
INSERT INTO `wx_amount` VALUES ('16', '1', '2', '1', '3');
INSERT INTO `wx_amount` VALUES ('17', '2', '10', '3', '2');
INSERT INTO `wx_amount` VALUES ('18', '3', '117', '2', '7');
INSERT INTO `wx_amount` VALUES ('19', '3', '117', '1', '1');
INSERT INTO `wx_amount` VALUES ('20', '3', '117', '0', '7');
INSERT INTO `wx_amount` VALUES ('21', '3', '117', '3', '18');
INSERT INTO `wx_amount` VALUES ('22', '3', '117', '4', '9');
INSERT INTO `wx_amount` VALUES ('23', '3', '117', '5', '12');
INSERT INTO `wx_amount` VALUES ('24', '3', '117', '6', '1');
INSERT INTO `wx_amount` VALUES ('25', '3', '117', '9', '1');
INSERT INTO `wx_amount` VALUES ('26', '3', '117', '11', '1');
INSERT INTO `wx_amount` VALUES ('27', '3', '7', '5', '1');
INSERT INTO `wx_amount` VALUES ('28', '3', '117', '13', '21');
INSERT INTO `wx_amount` VALUES ('29', '3', '117', '14', '10');
INSERT INTO `wx_amount` VALUES ('30', '3', '117', '15', '1');

-- ----------------------------
-- Table structure for `wx_category`
-- ----------------------------
DROP TABLE IF EXISTS `wx_category`;
CREATE TABLE `wx_category` (
  `cid` int(5) NOT NULL AUTO_INCREMENT,
  `pid` int(5) DEFAULT NULL COMMENT '上级分类',
  `name` varchar(20) DEFAULT NULL COMMENT '分类名称',
  `type` char(2) NOT NULL DEFAULT 'n',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分类表';

-- ----------------------------
-- Records of wx_category
-- ----------------------------

-- ----------------------------
-- Table structure for `wx_grid`
-- ----------------------------
DROP TABLE IF EXISTS `wx_grid`;
CREATE TABLE `wx_grid` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '资源名称',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '资源排序',
  `unkey` int(10) DEFAULT '0' COMMENT '资源主键',
  PRIMARY KEY (`id`),
  KEY `unkey` (`unkey`)
) ENGINE=MyISAM AUTO_INCREMENT=149 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wx_grid
-- ----------------------------
INSERT INTO `wx_grid` VALUES ('133', '村民代表', '2', '0');
INSERT INTO `wx_grid` VALUES ('134', '两代表-一委员', '1', '1');
INSERT INTO `wx_grid` VALUES ('135', '一长三员', '0', '2');
INSERT INTO `wx_grid` VALUES ('136', '党员', '3', '3');
INSERT INTO `wx_grid` VALUES ('137', '财政供养人员', '4', '4');
INSERT INTO `wx_grid` VALUES ('138', '“三老”人员', '5', '5');
INSERT INTO `wx_grid` VALUES ('139', '村聘用辅助人员', '6', '6');
INSERT INTO `wx_grid` VALUES ('140', '综治人员（人民调解员等）', '7', '7');
INSERT INTO `wx_grid` VALUES ('141', '保洁员', '8', '8');
INSERT INTO `wx_grid` VALUES ('142', '计生走访员', '9', '9');
INSERT INTO `wx_grid` VALUES ('143', '道德模范（甪直好人等）', '10', '10');
INSERT INTO `wx_grid` VALUES ('144', '劳动模范', '11', '11');
INSERT INTO `wx_grid` VALUES ('145', '最美家庭', '12', '12');
INSERT INTO `wx_grid` VALUES ('146', '光荣之家', '13', '13');
INSERT INTO `wx_grid` VALUES ('147', '荣誉表彰对象（三好学生等）', '14', '14');
INSERT INTO `wx_grid` VALUES ('148', '社会组织（连厢舞队等群众组织）', '14', '15');

-- ----------------------------
-- Table structure for `wx_level`
-- ----------------------------
DROP TABLE IF EXISTS `wx_level`;
CREATE TABLE `wx_level` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '资源名称',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '资源排序',
  `unkey` int(10) DEFAULT '0' COMMENT '资源主键',
  `pid` smallint(5) NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`),
  KEY `pid` (`pid`),
  KEY `unkey` (`unkey`)
) ENGINE=MyISAM AUTO_INCREMENT=133 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wx_level
-- ----------------------------
INSERT INTO `wx_level` VALUES ('1', '1', '区级网络-巡查员', '1', '0', '0', '0');
INSERT INTO `wx_level` VALUES ('2', '1', '区结对机关', '2', '1', '0', '1');
INSERT INTO `wx_level` VALUES ('3', '1', '其他资源', '3', '2', '0', '0');
INSERT INTO `wx_level` VALUES ('4', '2', '挂钩领导', '1', '0', '0', '0');
INSERT INTO `wx_level` VALUES ('5', '2', '蹲点干部', '2', '1', '0', '0');
INSERT INTO `wx_level` VALUES ('6', '2', '结对共建-资源', '3', '2', '0', '0');
INSERT INTO `wx_level` VALUES ('7', '3', '保圣社区', '1', '0', '0', '0');
INSERT INTO `wx_level` VALUES ('8', '3', '澄北村', '2', '1', '0', '0');
INSERT INTO `wx_level` VALUES ('9', '3', '澄东村', '3', '2', '0', '0');
INSERT INTO `wx_level` VALUES ('10', '2', '百人优培', '4', '3', '0', '0');
INSERT INTO `wx_level` VALUES ('11', '2', '水乡艺术团', '5', '4', '0', '0');
INSERT INTO `wx_level` VALUES ('12', '2', '甪直电影-放映队', '6', '5', '0', '0');
INSERT INTO `wx_level` VALUES ('13', '2', '非遗联盟', '7', '6', '0', '0');
INSERT INTO `wx_level` VALUES ('14', '2', '文联', '8', '7', '0', '0');
INSERT INTO `wx_level` VALUES ('28', '3', '瑶盛村', '17', '16', '0', '0');
INSERT INTO `wx_level` VALUES ('15', '3', '澄墩村', '4', '3', '0', '0');
INSERT INTO `wx_level` VALUES ('16', '3', '澄湖村', '5', '4', '0', '0');
INSERT INTO `wx_level` VALUES ('17', '3', '甫港村', '6', '5', '0', '0');
INSERT INTO `wx_level` VALUES ('18', '3', '甫里社区', '7', '6', '0', '0');
INSERT INTO `wx_level` VALUES ('19', '3', '甫南村', '8', '7', '0', '0');
INSERT INTO `wx_level` VALUES ('20', '3', '甫田村', '9', '8', '0', '0');
INSERT INTO `wx_level` VALUES ('21', '3', '湖浜村', '10', '9', '0', '0');
INSERT INTO `wx_level` VALUES ('22', '3', '江湾村', '11', '10', '0', '0');
INSERT INTO `wx_level` VALUES ('23', '3', '前港村', '12', '11', '0', '0');
INSERT INTO `wx_level` VALUES ('24', '3', '三马村', '13', '12', '0', '0');
INSERT INTO `wx_level` VALUES ('25', '3', '淞港村', '14', '13', '0', '0');
INSERT INTO `wx_level` VALUES ('26', '3', '淞南村', '15', '14', '0', '0');
INSERT INTO `wx_level` VALUES ('27', '3', '淞浦村', '16', '15', '0', '0');
INSERT INTO `wx_level` VALUES ('29', '3', '长巨村', '18', '17', '0', '0');
INSERT INTO `wx_level` VALUES ('30', '3', '网格（1）正阳', '1', '5', '7', '0');
INSERT INTO `wx_level` VALUES ('31', '3', '网格（2）中和', '2', '5', '7', '0');
INSERT INTO `wx_level` VALUES ('34', '3', '网格（3）建新', '3', '5', '7', '0');
INSERT INTO `wx_level` VALUES ('35', '3', '网格（4）南汇', '4', '5', '7', '0');
INSERT INTO `wx_level` VALUES ('36', '3', '网格（5）甪清1', '5', '5', '7', '0');
INSERT INTO `wx_level` VALUES ('37', '3', '网格（6）甪清2', '6', '5', '7', '0');
INSERT INTO `wx_level` VALUES ('38', '3', '网格（1）长腰浜、湾楼里、孙陶湾新村', '1', '4', '8', '0');
INSERT INTO `wx_level` VALUES ('39', '3', '网格（2）唐介浜、碛砂村', '2', '4', '8', '0');
INSERT INTO `wx_level` VALUES ('40', '3', '网格（3）陶巷', '3', '4', '8', '0');
INSERT INTO `wx_level` VALUES ('41', '3', '网格（4）柴积浜、及岸', '4', '4', '8', '0');
INSERT INTO `wx_level` VALUES ('42', '3', '网格（5）支家堰', '5', '4', '8', '0');
INSERT INTO `wx_level` VALUES ('43', '3', '网格（1）庆丰', '1', '3', '9', '0');
INSERT INTO `wx_level` VALUES ('44', '3', '网格（1）田东', '2', '3', '9', '0');
INSERT INTO `wx_level` VALUES ('45', '3', '网格（3）西塘', '3', '3', '9', '0');
INSERT INTO `wx_level` VALUES ('46', '3', '网格（4）凌塘', '4', '3', '9', '0');
INSERT INTO `wx_level` VALUES ('47', '3', '网格（1）旺墩上、石墩港', '1', '4', '15', '0');
INSERT INTO `wx_level` VALUES ('48', '3', '网格（2）朱夏浜甘蔗浜、六店桥', '2', '4', '15', '0');
INSERT INTO `wx_level` VALUES ('49', '3', '网格（3）陈华浜', '3', '4', '15', '0');
INSERT INTO `wx_level` VALUES ('50', '3', '网格（4）大姚、沈家浜', '4', '4', '15', '0');
INSERT INTO `wx_level` VALUES ('51', '3', '网格（5）斛谭上、朱家巨', '5', '4', '15', '0');
INSERT INTO `wx_level` VALUES ('52', '3', '网格（1）张林北片', '1', '4', '16', '0');
INSERT INTO `wx_level` VALUES ('53', '3', '网格（2）张林中片', '2', '4', '16', '0');
INSERT INTO `wx_level` VALUES ('54', '3', '网格（3）张林南片', '3', '4', '16', '0');
INSERT INTO `wx_level` VALUES ('55', '3', '网格（4）西庄南片', '4', '4', '16', '0');
INSERT INTO `wx_level` VALUES ('56', '3', '网格（5）西庄北片七圣浜、西庄四戈泾浜、薛介浜', '5', '4', '16', '0');
INSERT INTO `wx_level` VALUES ('57', '3', '网格（1）清水港、中段', '1', '5', '17', '0');
INSERT INTO `wx_level` VALUES ('58', '3', '网格（2）韩家浜', '2', '5', '17', '0');
INSERT INTO `wx_level` VALUES ('59', '3', '网格（3）正陶浜', '3', '5', '17', '0');
INSERT INTO `wx_level` VALUES ('60', '3', '网格（4）孙妃、东巫角新村、高家浜', '4', '5', '17', '0');
INSERT INTO `wx_level` VALUES ('61', '3', '网格（5）严家厍、邹家塘', '5', '5', '17', '0');
INSERT INTO `wx_level` VALUES ('62', '3', '网格（6）五谷村', '6', '5', '17', '0');
INSERT INTO `wx_level` VALUES ('63', '3', '网格（1）甫淞苑小区', '1', '4', '18', '0');
INSERT INTO `wx_level` VALUES ('64', '3', '网格（2）施村头', '2', '4', '18', '0');
INSERT INTO `wx_level` VALUES ('65', '3', '网格（3）支家厍、大娄', '3', '4', '18', '0');
INSERT INTO `wx_level` VALUES ('66', '3', '网格（4）张巷', '4', '4', '18', '0');
INSERT INTO `wx_level` VALUES ('67', '3', '网格（5）地园', '5', '4', '18', '0');
INSERT INTO `wx_level` VALUES ('68', '3', '网格（1）光辉', '1', '4', '19', '0');
INSERT INTO `wx_level` VALUES ('69', '3', '网格（2）黄楼村', '2', '4', '19', '0');
INSERT INTO `wx_level` VALUES ('70', '3', '网格（3）南桥村', '3', '4', '19', '0');
INSERT INTO `wx_level` VALUES ('71', '3', '网格（4）南场村', '4', '4', '19', '0');
INSERT INTO `wx_level` VALUES ('72', '3', '网格（5）工业区', '5', '4', '19', '0');
INSERT INTO `wx_level` VALUES ('73', '3', '网格（1）郭巷自然村', '1', '4', '20', '0');
INSERT INTO `wx_level` VALUES ('74', '3', '网格（2）公田自然村', '2', '4', '20', '0');
INSERT INTO `wx_level` VALUES ('75', '3', '网格（3）陆巷自然村', '3', '4', '20', '0');
INSERT INTO `wx_level` VALUES ('76', '3', '网格（4）联谊路企业', '4', '4', '20', '0');
INSERT INTO `wx_level` VALUES ('77', '3', '网格（5）长虹路企业', '5', '4', '20', '0');
INSERT INTO `wx_level` VALUES ('78', '3', '网格（1）西南湾、马家浜', '1', '3', '21', '0');
INSERT INTO `wx_level` VALUES ('79', '3', '网格（2）长浜里', '2', '3', '21', '0');
INSERT INTO `wx_level` VALUES ('80', '3', '网格（3）横港头', '3', '3', '21', '0');
INSERT INTO `wx_level` VALUES ('81', '3', '网格（4）田肚浜、节子浜', '4', '3', '21', '0');
INSERT INTO `wx_level` VALUES ('96', '3', '网格（1）江北', '1', '5', '22', '0');
INSERT INTO `wx_level` VALUES ('97', '3', '网格（2）江东', '2', '5', '22', '0');
INSERT INTO `wx_level` VALUES ('98', '3', '网格（3）江田北', '3', '5', '22', '0');
INSERT INTO `wx_level` VALUES ('99', '3', '网格（4）江田南', '4', '5', '22', '0');
INSERT INTO `wx_level` VALUES ('100', '3', '网格（5）西湾', '5', '5', '22', '0');
INSERT INTO `wx_level` VALUES ('101', '3', '网格（6）东湾', '6', '5', '22', '0');
INSERT INTO `wx_level` VALUES ('102', '3', '网格（1）张家潭、旗干浜、店前、张家潭、龚家湾', '1', '3', '23', '0');
INSERT INTO `wx_level` VALUES ('103', '3', '网格（2）陈家港', '2', '3', '23', '0');
INSERT INTO `wx_level` VALUES ('104', '3', '网格（3）江滩头、陆庄泾、葫芦浜、谈家湾、万古浜', '3', '3', '23', '0');
INSERT INTO `wx_level` VALUES ('105', '3', '网格（4）杨家桥、姚家浜', '4', '3', '23', '0');
INSERT INTO `wx_level` VALUES ('106', '3', '网格（1）三姑村东', '1', '4', '24', '0');
INSERT INTO `wx_level` VALUES ('107', '3', '网格（2）三姑村南', '2', '4', '24', '0');
INSERT INTO `wx_level` VALUES ('108', '3', '网格（3）沙浜', '3', '4', '24', '0');
INSERT INTO `wx_level` VALUES ('109', '3', '网格（4）杨树、张巷', '4', '4', '24', '0');
INSERT INTO `wx_level` VALUES ('110', '3', '网格（5）史家浜、南中北马塔', '5', '4', '24', '0');
INSERT INTO `wx_level` VALUES ('111', '3', '网格（1）淡村里、东港浪', '1', '4', '25', '0');
INSERT INTO `wx_level` VALUES ('112', '3', '网格（2）博克产业园周边区域以及凌港南村庄', '2', '4', '25', '0');
INSERT INTO `wx_level` VALUES ('113', '3', '网格（3）西潭', '3', '4', '25', '0');
INSERT INTO `wx_level` VALUES ('114', '3', '网格（4）凌港北', '4', '4', '25', '0');
INSERT INTO `wx_level` VALUES ('115', '3', '网格（5）双板桥', '5', '4', '25', '0');
INSERT INTO `wx_level` VALUES ('116', '3', '网格（1）云龙', '1', '4', '26', '0');
INSERT INTO `wx_level` VALUES ('117', '3', '网格（2）西横', '2', '4', '26', '0');
INSERT INTO `wx_level` VALUES ('118', '3', '网格（3）娄里', '3', '4', '26', '0');
INSERT INTO `wx_level` VALUES ('119', '3', '网格（4）北港', '4', '4', '26', '0');
INSERT INTO `wx_level` VALUES ('120', '3', '网格（5）大厍（含富丽新村）', '5', '4', '26', '0');
INSERT INTO `wx_level` VALUES ('121', '3', '网格（6）大厍工业区', '6', '18', '26', '0');
INSERT INTO `wx_level` VALUES ('122', '3', '网格（1）东关', '1', '2', '27', '0');
INSERT INTO `wx_level` VALUES ('123', '3', '网格（2）蒋浦', '2', '2', '27', '0');
INSERT INTO `wx_level` VALUES ('124', '3', '网格（3）秀皇', '3', '2', '27', '0');
INSERT INTO `wx_level` VALUES ('125', '3', '网格（1）东浜.西浜.上星其', '1', '3', '28', '0');
INSERT INTO `wx_level` VALUES ('126', '3', '网格（2）杨家浜.竹家浜.王家浜.北仁德', '2', '3', '28', '0');
INSERT INTO `wx_level` VALUES ('127', '3', '网格（3）沙湾.塔上.东蒋坞.西蒋坞', '3', '3', '28', '0');
INSERT INTO `wx_level` VALUES ('128', '3', '网格（4）南赞头.北赞头.娄里', '4', '3', '28', '0');
INSERT INTO `wx_level` VALUES ('129', '3', '网格（1）和尚港、长巨新村、西厍浜', '1', '3', '29', '0');
INSERT INTO `wx_level` VALUES ('130', '3', '网格（2）打三港、长巨自然村', '2', '3', '29', '0');
INSERT INTO `wx_level` VALUES ('131', '3', '网格（3）沈家荡、张家浜、倪家浜、沈家荡', '3', '3', '29', '0');
INSERT INTO `wx_level` VALUES ('132', '3', '网格（4）马娄里、朱家巨、沈家角、下扒浜', '4', '3', '29', '0');

-- ----------------------------
-- Table structure for `wx_link`
-- ----------------------------
DROP TABLE IF EXISTS `wx_link`;
CREATE TABLE `wx_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `status` int(1) NOT NULL,
  `link` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `sort` int(11) NOT NULL,
  `target` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wx_link
-- ----------------------------

-- ----------------------------
-- Table structure for `wx_member`
-- ----------------------------
DROP TABLE IF EXISTS `wx_member`;
CREATE TABLE `wx_member` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `cid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在等级',
  `lid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
  `unkey` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(30) NOT NULL DEFAULT '' COMMENT '手机号码',
  `reg_date` int(10) NOT NULL DEFAULT '0',
  `reg_ip` char(15) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `avatar` varchar(100) NOT NULL DEFAULT '' COMMENT '用户头像',
  `birthday` char(20) NOT NULL DEFAULT '' COMMENT '用户生日',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0女1男',
  `culture` varchar(100) NOT NULL DEFAULT '' COMMENT '文化程度',
  `politic` varchar(100) NOT NULL DEFAULT '' COMMENT '政治面貌',
  `unit` varchar(100) NOT NULL DEFAULT '' COMMENT '单位',
  `job` varchar(100) NOT NULL DEFAULT '' COMMENT '职务',
  `userno` char(20) NOT NULL DEFAULT '' COMMENT '户号',
  `rela` varchar(100) NOT NULL DEFAULT '' COMMENT '社会关系',
  `addr` varchar(200) NOT NULL DEFAULT '' COMMENT '地址',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0 未激活 1激活',
  `intr` varchar(500) NOT NULL DEFAULT '' COMMENT '个人介绍',
  `salt` char(10) NOT NULL DEFAULT '',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '积分',
  PRIMARY KEY (`uid`),
  KEY `name` (`name`),
  KEY `cid` (`cid`),
  KEY `lid` (`lid`),
  KEY `unkey` (`unkey`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='资源表';

-- ----------------------------
-- Records of wx_member
-- ----------------------------
INSERT INTO `wx_member` VALUES ('1', '3', '30', '0', '赵俊文', '13776325613', '1598610475', '49.75.203.167', '/Uploads/image/product/20200828/20200828090505_26701.png', '1985.12', '1', '本科', '党员', '澄湖村村委会', '澄湖村村副主任', '0000000', '1111111111', '甪直镇澄湖村西庄新村', '1', '甪直镇澄湖村西庄新村\n甪直镇澄湖村西庄新村\n甪直镇澄湖村西庄新村\n甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村甪直镇澄湖村西庄新村', '', '0');
INSERT INTO `wx_member` VALUES ('2', '3', '30', '2', '周炳荣', '13861302912', '1598611781', '49.75.203.167', '/Uploads/image/product/20200828/20200828090505_26701.png', '1961.08', '1', '高中', '党员', '澄湖村村委会', '澄湖村工作人员', '11111111', '111111', '甪直镇湖滨路51号', '1', '所得税的方式打广告光污染', '', '0');
INSERT INTO `wx_member` VALUES ('3', '3', '30', '1', '张建民', '13962529815', '1598612105', '49.75.203.167', '/Uploads/image/product/20200828/20200828090505_26701.png', '1967.10', '1', '初中', '党员', '甪直镇澄湖村', '澄湖村工作人员', '11111111', '1111111', '甪直镇澄湖村西庄(7)周介浜29号', '1', '哒哒哒哒哒哒多', '', '0');
INSERT INTO `wx_member` VALUES ('4', '3', '30', '3', '周国华', '15195632369', '1598612243', '49.75.203.167', '', '1985.04', '1', '本科', '党员', '澄湖村', '澄湖村工作人员', '11111111', '11111111', '甪直镇澄湖村西庄(7)周介浜2号', '1', '3333333333', '', '0');
INSERT INTO `wx_member` VALUES ('5', '3', '30', '1', '张建芳', '18020251029', '1598612399', '49.75.203.167', '', '1977.10', '0', '大专', '党员', '澄湖村', '澄湖村工作人员', '11111111', '11111111', '甪直镇澄湖村西庄（6）周介浜24号', '1', '阿根廷和我回头问他吧', '', '0');
INSERT INTO `wx_member` VALUES ('6', '3', '30', '4', '仲凤金', '18915507231', '1598612470', '49.75.203.167', '', '1964.06', '0', '高中', '党员', '澄湖村', '无', '11111111', '11111111', '甪直镇澄湖村西庄(4)西庄新村16号', '1', '热热热', '', '0');
INSERT INTO `wx_member` VALUES ('7', '3', '30', '1', '许老火', '15995749790', '1598612551', '49.75.203.167', '', '1950.10', '1', '小学', '党员', '澄湖村', '无', '11111111', '11111111', '甪直镇澄湖村湖滨路51号', '1', '咕咕咕咕咕咕', '', '0');
INSERT INTO `wx_member` VALUES ('8', '3', '30', '1', '赵小男', '65012110', '1598612605', '49.75.203.167', '', '1938.09', '1', '小学', '党员', '澄湖村', '无', '11111111', '11111111', '甪直镇澄湖村湖滨路51号', '1', '前期前期qqqqq', '', '0');
INSERT INTO `wx_member` VALUES ('9', '3', '30', '1', '赵云元', '65016208', '1598612658', '49.75.203.167', '', '1952.08', '1', '小学', '党员', '澄湖村', '无', '11111111', '11111111', '甪直镇湖滨路51号', '1', '少时诵诗书', '', '0');
INSERT INTO `wx_member` VALUES ('10', '3', '30', '1', '赵大男', '65041082', '1598612728', '49.75.203.167', '', '1931.08', '1', '小学', '党员', '澄湖村', '无', '11111111', '11111111', '甪直镇湖滨路51号', '1', '怀化市生态', '', '0');
INSERT INTO `wx_member` VALUES ('11', '1', '3', '1', '许火荣', '18915515368', '1598612796', '49.75.203.167', '', '1962.10', '1', '初中', '党员', '澄湖村', '上海海关职工', '11111111', '11111111', '甪直镇湖滨路51号', '1', '发放给', '', '0');
INSERT INTO `wx_member` VALUES ('12', '3', '30', '0', '赵秋根', '65014980', '1598612916', '49.75.203.167', '', '1970.01', '1', '初中', '党员', '澄湖村', '无', '11111111', '11111111222', '甪直镇湖滨路51号', '1', '热热热热热', '', '0');
INSERT INTO `wx_member` VALUES ('17', '2', '10', '3', '邹诚杰', '13912697863', '1599552780', '58.210.45.170', '/uploads/image/images/20200908/20200908081252_40366.jpg', '1986.10', '1', '硕士', '群众', '甪直镇建设局', '规划建设科科长', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('19', '2', '10', '3', '金彬', '15906216606', '1599554378', '58.210.45.170', '/uploads/image/images/20200908/20200908083936_82537.jpg', '1992.12', '0', '大专', '中共党员', '党政办机要法制科', '工作人员　', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('21', '1', '2', '1', '对对对', '15195632369', '1599555605', '180.117.179.13', '/Uploads/image/images/20200908/20200908084404_18456.jpg', '1985.04', '0', '小学', '党员', '澄湖村', '无', '11111111', '11111111', '澄湖村西庄(5)西庄新村49号', '0', '', '', '0');
INSERT INTO `wx_member` VALUES ('22', '1', '2', '1', '陈洁琼', '0512-65252250', '1599555756', '58.210.45.170', '/Uploads/image/images/20200908/20200908080535_93839.jpg', '1990.02', '0', '研究生', '中共党员', '团区委办公室', '科员', '1', '1', '1', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('24', '3', '117', '2', '归央根', '18915551592', '1599613119', '58.210.45.170', '/uploads/image/images/20200909/20200909005828_55274.jpg', '1964.05', '1', '大专', '中共党员', '淞南村', '淞南村党委委员、西横网格长', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('25', '3', '117', '2', '钱晓英', '13862012441', '1599613245', '58.210.45.170', '/uploads/image/images/20200909/20200909010036_23219.jpg', '1986.11', '0', '大专', '中共党员', '淞南村', '淞南村纪委书记、妇联主席、西横网格员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('26', '3', '117', '2', '金建冬', '13451671540', '1599613344', '58.210.45.170', '/uploads/image/images/20200909/20200909010210_35812.jpg', '1972.05', '1', '大专', '中共党员', '淞南村', '淞南村工作人员、西横网格员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('27', '3', '117', '2', '金婷怡', '13861322804', '1599724386', '58.210.45.170', '/uploads/image/images/20200910/20200910075304_81117.jpg', '1993.07', '0', '本科', '共青团员', '淞南村', '淞南村妇联副主席、西横网格员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('28', '3', '117', '2', '归春花', '13862425216', '1599724446', '58.210.45.170', '/uploads/image/images/20200910/20200910075402_14905.jpg', '1968.12', '0', '中专', '群众', '西横网格', '参与员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('29', '3', '117', '2', '金永林', '13402500818', '1599724493', '58.210.45.170', '/uploads/image/images/20200910/20200910075452_69532.jpg', '1956.10', '1', '初中', '中共党员', '西横网格', '参与员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('30', '3', '117', '2', '马大虎根', '18994448372', '1599724625', '58.210.45.170', '/uploads/image/images/20200910/20200910075637_71193.jpg', '1949.09', '1', '小学', '中共党员', '西横网格', '参与员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('32', '3', '117', '1', '成建国', '13913563256', '1599725007', '58.210.45.170', '/uploads/image/images/20200910/20200910080201_27418.jpg', '1977.07', '1', '本科', '知联会', '甪直人民医院', '外科主治医师', '', '', '', '1', '2020.06.30“有事好商量”政协协商议事', '', '0');
INSERT INTO `wx_member` VALUES ('34', '3', '117', '0', '归冬林', '13013887531', '1599725274', '58.210.45.170', '/uploads/image/images/20200910/20200910080749_60575.jpg', '1953.11', '1', '小学', '群众', '横江村', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('35', '3', '117', '0', '顾秋凤', '13812631138', '1599725334', '58.210.45.170', '/uploads/image/images/20200910/20200910080851_21620.jpg', '1958.06', '0', '小学', '中共党员', '横江村', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('36', '3', '117', '0', '马凤根', '13915516602', '1599725409', '58.210.45.170', '/uploads/image/images/20200910/20200910081000_74478.jpg', '1956.08', '1', '初中', '中共党员', '横江村', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('37', '3', '117', '0', '高坤荣', '13914040736', '1599725465', '58.210.45.170', '/uploads/image/images/20200910/20200910081101_14356.jpg', '1963.12', '1', '初中', '群众', '横江村', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('38', '3', '117', '0', '金海林', '13776053083', '1599725514', '58.210.45.170', '/uploads/image/images/20200910/20200910081152_63654.jpg', '1953.07', '1', '初中', '群众', '西江浜', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('39', '3', '117', '0', '金林荣', '15962131153', '1599725563', '58.210.45.170', '', '1966.01', '1', '', '群众', '西江浜', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('41', '3', '117', '3', '马大虎根', '15850009001', '1599725638', '58.210.45.170', '/uploads/image/images/20200910/20200910081350_20906.jpg', '1949.09', '1', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('42', '3', '117', '3', '归金土', '13862052417', '1599725733', '58.210.45.170', '/uploads/image/images/20200910/20200910081714_45332.jpg', '1948.08', '1', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('43', '3', '117', '3', '归小男', '13913128213', '1599725787', '58.210.45.170', '/uploads/image/images/20200910/20200910081623_47265.jpg', '1950.11', '1', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('44', '3', '117', '3', '马凤根', '13915516602', '1599725911', '58.210.45.170', '/uploads/image/images/20200910/20200910081829_55859.jpg', '1956.08', '1', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('45', '3', '117', '3', '顾秋凤', '13812639138', '1599725963', '58.210.45.170', '/uploads/image/images/20200910/20200910081922_68705.jpg', '1958.06', '0', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('46', '3', '117', '3', '归海生', '13506215021', '1599726027', '58.210.45.170', '/uploads/image/images/20200910/20200910082020_33112.jpg', '1958.08', '1', '大专', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('47', '3', '117', '3', '归央根', '13771784982', '1599726098', '58.210.45.170', '/uploads/image/images/20200910/20200910082133_25097.jpg', '1964.05', '1', '大专', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('48', '3', '117', '3', '钱晓英', '13862012441', '1599726148', '58.210.45.170', '/uploads/image/images/20200910/20200910082226_45678.jpg', '1986.11', '0', '大专', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('49', '3', '117', '3', '金增元', '13646221889', '1599726187', '58.210.45.170', '/uploads/image/images/20200910/20200910082306_43132.jpg', '1929.03', '1', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('50', '3', '117', '3', '归根土', '13862425216', '1599726223', '58.210.45.170', '/uploads/image/images/20200910/20200910082342_33323.jpg', '1945.1', '1', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('51', '3', '117', '3', '归根水', '0512-65010097', '1599726259', '58.210.45.170', '/uploads/image/images/20200910/20200910082418_45452.jpg', '1946.12', '1', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('52', '3', '117', '3', '顾金龙', '15358810608', '1599726334', '58.210.45.170', '/uploads/image/images/20200910/20200910082529_39207.jpg', '1947.1', '1', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('53', '3', '117', '3', '陆伯全', '13402687178', '1599726490', '58.210.45.170', '/uploads/image/images/20200910/20200910082807_21395.jpg', '1949.05', '1', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('54', '3', '117', '3', '陆雪泉', '13771836458', '1599726555', '58.210.45.170', '/uploads/image/images/20200910/20200910082910_85923.jpg', '1951.01', '1', '小学', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('55', '3', '117', '3', '金海林', '13606214380', '1599726666', '58.210.45.170', '/uploads/image/images/20200910/20200910083004_52742.jpg', '1955.06', '1', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('56', '3', '117', '3', '金永林', '13402500818', '1599726745', '58.210.45.170', '/uploads/image/images/20200910/20200910083219_35378.jpg', '1956.1', '1', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('57', '3', '117', '3', '金建冬', '13451671540', '1599726787', '58.210.45.170', '/uploads/image/images/20200910/20200910083305_31255.jpg', '1972.05', '1', '大专', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('58', '3', '117', '3', '袁凤花', '15501460830', '1599726821', '58.210.45.170', '/uploads/image/images/20200910/20200910083339_16569.jpg', '1969.1', '0', '初中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('60', '3', '117', '4', '周志良', '13511600338', '1599726901', '58.210.45.170', '/uploads/image/images/20200910/20200910083456_76404.jpg', '1981.10', '1', '本科', '中共党员', '甪直交警中队', '辅警', '', '', '', '1', '2020.03.28淞南村人居环境宣传及整治\n', '', '0');
INSERT INTO `wx_member` VALUES ('61', '3', '117', '4', '金珠　', '15051525122', '1599726965', '58.210.45.170', '/uploads/image/images/20200910/20200910083604_96267.jpg', '1988.12', '0', '本科', '群众', '财政和资产管理局财务管理科　', '工作人员', '', '', '', '1', '2020.03.28淞南村人居环境宣传及整治\n', '', '0');
INSERT INTO `wx_member` VALUES ('62', '3', '117', '4', '金俊峰', '15250025960', '1599727036', '58.210.45.170', '/uploads/image/images/20200910/20200910083714_69298.jpg', '1990.12', '1', '本科', '中共预备党员', '环境卫生管理所办公室', '管理员', '', '', '', '1', '2020.03.28淞南村人居环境宣传及整治\n', '', '0');
INSERT INTO `wx_member` VALUES ('63', '3', '117', '4', '归凯雅', '13915549576', '1599727081', '58.210.45.170', '/uploads/image/images/20200910/20200910083759_74396.jpg', '1993.12', '0', '本科', '中共党员', '甪直人民医院', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('64', '3', '117', '4', '陆敏敏', '18913546466', '1599727134', '58.210.45.170', '/uploads/image/images/20200910/20200910083851_79672.jpg', '1986.08', '1', '本科', '中共党员', '城乡一体化 ', '副总经理', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('65', '3', '117', '4', '马越涛', '13196680365', '1599727190', '58.210.45.170', '/uploads/image/images/20200910/20200910083946_84366.jpg', '1996.12', '1', '本科', '共青团员', '综合行政执法局 ', '工作人员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('66', '3', '117', '4', '金亚', '18862383893', '1599727246', '58.210.45.170', '/uploads/image/images/20200910/20200910084036_89225.jpg', '1991.10', '0', '本科', '中共预备党员', '总工会', '工作人员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('67', '3', '117', '4', '归庆华', '13052813150', '1599727305', '58.210.45.170', '/uploads/image/images/20200910/20200910084144_79620.png', '1980.07', '1', '中专', '中共党员', '甪直集贸市场（龙潭农贸市场）', '外围组长', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('68', '3', '117', '4', '盛振华', '13451555670', '1599727349', '58.210.45.170', '/uploads/image/images/20200910/20200910084228_77417.jpg', '1980.12', '1', '初中以下', '中共党员', '甪直派出所辅警大队', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('70', '3', '117', '5', '马大虎根', '15850009001', '1599727453', '58.210.45.170', '/uploads/image/images/20200910/20200910084355_21900.jpg', '1949.09', '1', '小学', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('71', '3', '117', '5', '归金土', '13862052417', '1599727515', '58.210.45.170', '/uploads/image/images/20200910/20200910084510_77112.jpg', '1948.08', '1', '小学', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('72', '3', '117', '5', '马凤根', '13915516602', '1599727564', '58.210.45.170', '/uploads/image/images/20200910/20200910084602_76225.jpg', '1956.08', '1', '初中', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('73', '3', '117', '5', '顾秋凤', '13812639138', '1599727603', '58.210.45.170', '/uploads/image/images/20200910/20200910084642_29077.jpg', '1958.06', '0', '小学', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('74', '3', '117', '5', '顾金龙', '15358810608', '1599727643', '58.210.45.170', '/uploads/image/images/20200910/20200910084722_84995.jpg', '1947.1', '1', '初中', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('75', '3', '117', '5', '陆伯全', '13402687178', '1599727679', '58.210.45.170', '/uploads/image/images/20200910/20200910084758_28069.jpg', '1949.05', '1', '小学', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('76', '3', '117', '5', '陆雪泉', '13771836458', '1599727725', '58.210.45.170', '/uploads/image/images/20200910/20200910084844_27001.jpg', '1951.01', '1', '小学', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('77', '3', '117', '5', '金永林', '13402500818', '1599727770', '58.210.45.170', '/uploads/image/images/20200910/20200910084927_99865.jpg', '1956.1', '1', '初中', '中共党员', '', '老党员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('78', '3', '117', '5', '金增元', '13646221889', '1599727839', '58.210.45.170', '/uploads/image/images/20200910/20200910085035_40541.jpg', '1929.03', '1', '小学', '中共党员', '', '老干部', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('79', '3', '117', '5', '归根土', '13862425216', '1599727879', '58.210.45.170', '/uploads/image/images/20200910/20200910085118_65483.jpg', '1945.1', '1', '初中', '中共党员', '', '老干部', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('80', '3', '117', '5', '归根水', '0512-65010097', '1599727924', '58.210.45.170', '/uploads/image/images/20200910/20200910085202_60223.jpg', '1946.12', '1', '小学', '中共党员', '', '老干部', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('82', '3', '117', '6', '归根水', '0512-65010097', '1599728036', '58.210.45.170', '/uploads/image/images/20200910/20200910085352_31134.jpg', '1946.12', '1', '小学', '中共党员', '', '民主理财小组成员', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('84', '3', '117', '9', '归春花', '13862425216', '1599728097', '58.210.45.170', '/uploads/image/images/20200910/20200910085451_41893.jpg', '1968.12', '0', '中专', '群众', '横江村', '村民', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('86', '3', '117', '11', '归海生', '13506215021', '1599728167', '58.210.45.170', '/uploads/image/images/20200910/20200910085552_20272.jpg', '1958.08', '1', '大专', '中共党员', '', '吴中区劳模', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('87', '3', '117', '5', '高金根', '111', '1599728214', '58.210.45.170', '', '1938.10', '1', '', '群众', '', '老队长', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('89', '3', '7', '5', '金满生', '111', '1599728279', '58.210.45.170', '', '1933.12', '1', '', '群众', '', '老队长', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('91', '3', '117', '13', '顾金龙', '15358816608', '1599728340', '58.210.45.170', '/uploads/image/images/20200910/20200910085854_89203.jpg', '1947.10', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('92', '3', '117', '13', '金永林', '13402500818', '1599728388', '58.210.45.170', '/uploads/image/images/20200910/20200910085947_86272.jpg', '1956.10', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('93', '3', '117', '13', '马凤根', '13915516602', '1599728432', '58.210.45.170', '/uploads/image/images/20200910/20200910090030_15902.jpg', '1956.08', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('94', '3', '117', '13', '陆伯全', '13402687178', '1599728473', '58.210.45.170', '/uploads/image/images/20200910/20200910090111_18555.jpg', '1949.05', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('95', '3', '117', '13', '金星', '13862562812', '1599728499', '58.210.45.170', '', '1985.01', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('96', '3', '117', '13', '盛振华', '13451555670', '1599728536', '58.210.45.170', '/uploads/image/images/20200910/20200910090215_16487.jpg', '1980.12', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('97', '3', '117', '13', '归多林', '13451524698', '1599728585', '58.210.45.170', '/uploads/image/images/20200910/20200910090258_94748.jpg', '1967.04', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('98', '3', '117', '13', '陆雪泉', '13771836458', '1599728625', '58.210.45.170', '/uploads/image/images/20200910/20200910090344_90246.jpg', '1951.01', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('99', '3', '117', '13', '归建荣', '13402616818', '1599728663', '58.210.45.170', '/uploads/image/images/20200910/20200910090421_61973.jpg', '1971.12', '1', '高中', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('100', '3', '117', '13', '归金土', '13862052417', '1599728700', '58.210.45.170', '/uploads/image/images/20200910/20200910090459_30030.jpg', '1948.08', '1', '初中以下', '中共党员', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('101', '3', '117', '13', '陆冬林', '13732640574', '1599728772', '58.210.45.170', '', '1957.08', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('102', '3', '117', '13', '顾根林', '18344682267', '1599728837', '58.210.45.170', '', '1942.11', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('103', '3', '117', '13', '顾荣林', '13402650547', '1599728870', '58.210.45.170', '', '1940.03', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('104', '3', '117', '0', '周建根', '17715144203', '1599728901', '58.210.45.170', '', '1960.06', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('105', '3', '117', '13', '陆金根', '1377169502', '1599728946', '58.210.45.170', '', '1946.10', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('106', '3', '117', '13', '周志华', '13912631877', '1599728974', '58.210.45.170', '', '1985.08', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('107', '3', '117', '13', '赵静根', '13862596280', '1599729002', '58.210.45.170', '', '1979.02', '1', '初中以下', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('108', '3', '117', '13', '盛顺亮', '13962152642', '1599729033', '58.210.45.170', '', '1993.12', '1', '中专（中技）', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('109', '3', '117', '13', '顾强', '15151427669', '1599729084', '58.210.45.170', '', '1991.11', '1', '大学专科（高职）', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('110', '3', '117', '13', '顾伟冬', '13912611341', '1599729110', '58.210.45.170', '', '1979.08', '1', '高中', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('111', '3', '117', '13', '许文', '15195683959', '1599729144', '58.210.45.170', '', '1990.10', '1', '中专（中技）', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('112', '3', '117', '13', '归毅恒', '18914031759', '1599729172', '58.210.45.170', '', '1996.04', '1', '中专（中技）', '群众', '', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('114', '3', '117', '14', '周宇', '13806138332', '1599729247', '58.210.45.170', '', '2003.03', '0', '', '共青团员', '苏苑中学', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('115', '3', '117', '14', '金燕', '13451981713', '1599729299', '58.210.45.170', '', '1995.07', '0', '', '共青团员', '上海交通大学 上海高级金融学院', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('116', '3', '117', '14', '陆锦叶', '13771842486', '1599729351', '58.210.45.170', '', '1999.12', '0', '', '共青团员', '南京师范大学泰州学院 数学与应用数学（师范）', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('117', '3', '117', '14', '陆依芊', '13861310052', '1599729396', '58.210.45.170', '', '2000.03', '0', '', '共青团员', '南京师范大学泰州学院 物理学（师范）', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('118', '3', '117', '14', '陆志刚', '13952403914', '1599729438', '58.210.45.170', '', '1996.01', '1', '', '共青团员', '浙江师范大学 数理与信息工程学院 物理学', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('119', '3', '117', '14', '马璟尧', '15950905593', '1599729470', '58.210.45.170', '', '2003.06', '1', '', '共青团员', '苏苑中学', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('120', '3', '117', '14', '马靖叶', '18013176152', '1599729519', '58.210.45.170', '', '2002.11', '0', '', '', '泰州学院 数学与应用数学（师范）', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('121', '3', '117', '14', '归语悦', '13732632315', '1599729557', '58.210.45.170', '', '2004.06', '0', '', '共青团员', '苏苑中学', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('122', '3', '117', '14', '陆智颖', '13771836458', '1599729590', '58.210.45.170', '', '2003.11', '0', '', '共青团员', '苏苑中学', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('123', '3', '117', '14', '归梓成', '15962143253', '1599729636', '58.210.45.170', '', '1997.03', '1', '研究生', '共青团员', '中国地质大学', '', '', '', '', '1', '', '', '0');
INSERT INTO `wx_member` VALUES ('125', '3', '117', '15', '盛培珍', '15995841835', '1599729673', '58.210.45.170', '', '1968.01', '0', '', '群众', '', '', '', '', '', '1', '', '', '0');

-- ----------------------------
-- Table structure for `wx_member_level`
-- ----------------------------
DROP TABLE IF EXISTS `wx_member_level`;
CREATE TABLE `wx_member_level` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(30) DEFAULT NULL COMMENT '头衔名称',
  `amount` decimal(10,2) DEFAULT NULL COMMENT '等级必要金额',
  `discount` smallint(4) DEFAULT NULL COMMENT '折扣',
  `describe` varchar(200) DEFAULT NULL COMMENT '头街 描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wx_member_level
-- ----------------------------

-- ----------------------------
-- Table structure for `wx_nav`
-- ----------------------------
DROP TABLE IF EXISTS `wx_nav`;
CREATE TABLE `wx_nav` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `nav_name` varchar(255) NOT NULL,
  `pid` smallint(5) NOT NULL DEFAULT '0',
  `status` tinyint(1) DEFAULT NULL,
  `link` varchar(225) NOT NULL,
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '50',
  `target` char(20) NOT NULL DEFAULT '',
  `title` varchar(50) DEFAULT NULL COMMENT 'SEO标题',
  `keywords` varchar(150) DEFAULT NULL COMMENT 'SEO关键字',
  `description` varchar(200) DEFAULT NULL COMMENT 'SEO描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wx_nav
-- ----------------------------

-- ----------------------------
-- Table structure for `wx_news`
-- ----------------------------
DROP TABLE IF EXISTS `wx_news`;
CREATE TABLE `wx_news` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '关联资源ID',
  `uname` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(200) DEFAULT NULL COMMENT '新闻标题',
  `keywords` varchar(50) DEFAULT NULL COMMENT '文章关键字',
  `description` mediumtext COMMENT '文章描述',
  `link` varchar(200) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL COMMENT '文章摘要',
  `addtime` datetime DEFAULT NULL,
  `content` text,
  `click` int(11) NOT NULL DEFAULT '0',
  `aid` smallint(3) DEFAULT NULL COMMENT '发布者UID',
  `is_recommend` int(1) NOT NULL DEFAULT '0',
  `titlepic` varchar(200) NOT NULL DEFAULT '',
  `cid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在等级',
  `lid` smallint(3) NOT NULL DEFAULT '0' COMMENT '所在分类',
  PRIMARY KEY (`id`),
  KEY `cid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='新闻表';

-- ----------------------------
-- Records of wx_news
-- ----------------------------
INSERT INTO `wx_news` VALUES ('1', '1', '赵俊文', '活动信息3', null, null, '', '1', '12312312', '2020-08-27 19:08:56', '&lt;p align=&quot;center&quot;&gt;\n	活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3\n&lt;/p&gt;\n&lt;p align=&quot;center&quot;&gt;\n	活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3\n&lt;/p&gt;\n&lt;p align=&quot;center&quot;&gt;\n	活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3活动信息3\n&lt;/p&gt;\n&lt;p align=&quot;center&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p align=&quot;center&quot;&gt;\n	&lt;img src=&quot;http://lz.bingheji.net/uploads/image/product/20200828/20200828090505_26701.png&quot; alt=&quot;&quot; /&gt; \n&lt;/p&gt;\n&lt;p align=&quot;center&quot;&gt;\n	213123123124234234234234234\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;', '30', '1', '10', '', '1', '2');
INSERT INTO `wx_news` VALUES ('2', '1', '赵俊文', '活动信息2', null, null, '', '1', '', '2020-08-28 17:00:40', '&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 国务院扶贫办副主任洪天云表示，我们肯定直播带货是个非常好的形式，我们非常鼓励、非常欢迎，而且一些贫困地区的县长、书记还主动站出来直播带货，我们不反对，但是不完全倡导，但是对名人，特别是各个方面在消费者中有影响力、带动力的直播带货相关人士我们是高度肯定和鼓励的。这是一个方面。第二，直播带货目前也出现了小情况，贫困地区对直播带货的产品算两本账，我们讲扶贫产品在贫困地区发展产业是一个重要的事情，帮助贫困地区宣传，帮助贫困地区直播带货，让它扩大影响，好酒也怕巷子深，需要在这块做。另外一方面要算经济账，目前我们发现少数地区请名人大牌，最后算账下来，直播带货请名人花的费用和直播带货以后的效应不成正比，成反比，花了好几十万、上百万，最后直播带货的销售才小几十万，这个账怎么算算不过来，所以这方面也是教训，也对以后的工作提出了新的要求。\n&lt;p&gt;\n	&lt;strong&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&lt;span style=&quot;background-color:#E56600;&quot;&gt;&amp;nbsp;&amp;nbsp; \n另外一方面，总的来说，现在贫困地区产业扶贫成果大规模展现，但是我们客观地看到，扶贫产业发展是有周期、有规律，是有一个长时间的过程的，现在贫困地区由于相关物流条件、发展条件和现代设施的相关条件比发达地区和内地发展好的地区差。习近平总书记在7月30日作出重大部署，提出以国内大循环为主体，国内国际双循环相互促进新发展格局的要求，我们贫困地区要全力以赴参与进来、介入进来。但是，另一方面大家知道，扶贫产品很多产业的产业链条不长，链条比较脆弱，在工作过程中，各个环节中信息化、智能化管理水平比较低，扶贫产品的规模化、标准化、品牌化水平不高，特别是物流配送和物流设施都还有差距，这些都需要我们在今年攻坚战剩下的几个月时间里把相关短板补好、补齐，同时，在“十四五”这五年规划中把这项工作作为重点，把相关的困难问题考虑更多一些，推进扶贫产品和市场的有效对接，参与大循环、参与市场化的大竞争，大家知道，由于贫困地区是市场信号比较弱的地方，政府还要继续发挥主导作用。&lt;/span&gt;&lt;/strong&gt; \n&lt;/p&gt;', '15', '1', '10', '', '1', '2');
INSERT INTO `wx_news` VALUES ('3', '1', '赵俊文', '活动信息1', null, null, '', '1', '', '2020-08-28 18:31:58', '&lt;p&gt;\n	详情详情&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;span&gt;详情详情&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span&gt;&lt;img src=&quot;http://lz.bingheji.net/Uploads/image/product/20200828/20200828090505_26701.png&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '4', '1', '10', '/Uploads/image/product/20200828/20200828090505_26701.png', '1', '2');
INSERT INTO `wx_news` VALUES ('5', '6', '仲凤金', '测试', null, null, '', '1', '测试', '2020-09-04 19:57:36', '测试', '0', '2', '1', '', '1', '2');

-- ----------------------------
-- Table structure for `wx_node`
-- ----------------------------
DROP TABLE IF EXISTS `wx_node`;
CREATE TABLE `wx_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL COMMENT '权限名字',
  `group` varchar(20) DEFAULT NULL COMMENT '所属分组',
  `right` text COMMENT '权限码(控制器+动作)',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除状态 1删除,0正常',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wx_node
-- ----------------------------
INSERT INTO `wx_node` VALUES ('1', '基本设置', 'system', 'System@index', '0');
INSERT INTO `wx_node` VALUES ('2', '清除缓存', 'system', 'System@cleancache', '0');
INSERT INTO `wx_node` VALUES ('3', '管理员列表', 'Site', 'System@admin,System@addAdmin,System@editAdmin', '0');
INSERT INTO `wx_node` VALUES ('4', '角色管理', 'system', 'System@role,System@addRole,System@editRole,System@delRole', '0');
INSERT INTO `wx_node` VALUES ('5', '权限列表', 'system', 'System@nodeList,System@addNode,System@editNode,System@delNode', '0');
INSERT INTO `wx_node` VALUES ('6', '操作日志', 'system', 'System@adminLog,System@delLog', '0');
INSERT INTO `wx_node` VALUES ('7', '数据备份', 'system', 'System@backup', '0');
INSERT INTO `wx_node` VALUES ('11', '友情链接', 'Site', 'Site@linkList,Site@addLink,Site@editLink,Site@delLink', '0');
INSERT INTO `wx_node` VALUES ('12', '导航菜单', 'Site', 'Site@nav,Site@addNav,Site@editNav,Site@delNav', '0');
INSERT INTO `wx_node` VALUES ('13', '广告位', 'Site', 'Site@adCate,Site@addAdCate,Site@editAdCate,Site@delAdCate', '0');
INSERT INTO `wx_node` VALUES ('14', '广告列表', 'Site', 'Site@adList,Site@addAdList,Site@editAdList,Site@delAdList', '0');
INSERT INTO `wx_node` VALUES ('17', '资源列表', 'User', 'User@index,User@addUser,User@delUser,User@editUser,User@getLevel', '0');
INSERT INTO `wx_node` VALUES ('18', '资源分类', 'User', 'User@level,User@addlevel,User@editlevel', '0');
INSERT INTO `wx_node` VALUES ('19', '网格列表', 'User', 'User@grid,User@addGrid,User@editGrid', '0');
INSERT INTO `wx_node` VALUES ('20', '信息管理', 'Site', 'Site@index,Site@addNews,Site@editNews,Site@delNews,Site@changeStatus', '0');

-- ----------------------------
-- Table structure for `wx_page`
-- ----------------------------
DROP TABLE IF EXISTS `wx_page`;
CREATE TABLE `wx_page` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL COMMENT '新闻标题',
  `unique_id` varchar(30) NOT NULL DEFAULT '',
  `keywords` varchar(50) DEFAULT NULL COMMENT '文章关键字',
  `description` mediumtext COMMENT '文章描述',
  `link` varchar(200) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL COMMENT '文章摘要',
  `addtime` datetime DEFAULT NULL,
  `content` text,
  `click` int(11) NOT NULL DEFAULT '0',
  `aid` smallint(3) DEFAULT NULL COMMENT '发布者UID',
  `is_recommend` int(1) NOT NULL DEFAULT '0',
  `titlepic` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_id` (`unique_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='单页表';

-- ----------------------------
-- Records of wx_page
-- ----------------------------

-- ----------------------------
-- Table structure for `wx_role`
-- ----------------------------
DROP TABLE IF EXISTS `wx_role`;
CREATE TABLE `wx_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `pid` int(4) NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `remark` varchar(255) DEFAULT '0',
  `act_list` text COMMENT '权限列表',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='权限角色表';

-- ----------------------------
-- Records of wx_role
-- ----------------------------
INSERT INTO `wx_role` VALUES ('1', '超级管理员', '0', '1', '系统内置超级管理员组，不受权限分配账号限制', 'all');
INSERT INTO `wx_role` VALUES ('2', '网格长', '1', '1', '资料管理', '2,13,14,20,17');
